(defproject thi.ng/geom-voxel "0.0.770"
  :description  "thi.ng geometry kit - voxel module"
  :url          "https://github.com/thi-ng/geom"
  :license      {:name "Apache Software License"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/geom"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.7.0-alpha5"]
                 [thi.ng/geom-core "0.0.770"]
                 [thi.ng/geom-types "0.0.770"]
                 [thi.ng/geom-meshops "0.0.770"]]

  :source-paths ["src/cljx"]
  :test-paths   ["target/test-classes"]

  :profiles     {:dev {:dependencies [[org.clojure/clojurescript "0.0-3117"]
                                      [criterium "0.4.3"]]
                       :plugins      [[com.keminglabs/cljx "0.6.0"]
                                      [lein-cljsbuild "1.0.5"]
                                      [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :auto-clean false
                       :prep-tasks [["cljx" "once"]]
                       :aliases {"cleantest" ["do" "clean," "cljx" "once," "test," "cljsbuild" "test"]}}}

  :cljx         {:builds [{:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :clj}
                          {:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :cljs}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :clj}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :cljs}]}

  :cljsbuild    {:builds [{:source-paths ["target/classes" "target/test-classes"]
                           :id "simple"
                           :compiler {:output-to "target/geom-voxel-0.0.770.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/geom-voxel-0.0.770.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
