(ns thi.ng.geom.webgl.shaders.lambert)

(def shader-spec
  {:vs "void main() {
  vec3 tNormal = normalize((normalMat * vec4(normal, 0.0)).xyz);

  float lambert = min(max(dot(tNormal, lightDir), 0.0), 1.0);
  vCol = vec4(ambientCol + diffuseCol * lightCol * lambert, alpha);
  gl_Position = proj * view * model * vec4(position, 1.0);
}"
   :fs "void main() { gl_FragColor = vCol; }"
   :uniforms {:model      :mat4
              :view       :mat4
              :normalMat  :mat4
              :proj       :mat4
              :ambientCol :vec3
              :diffuseCol :vec3
              :lightCol   :vec3
              :lightDir   :vec3
              :alpha      :float}
   :attribs  {:position   :vec3
              :normal     :vec3}
   :varying  {:vCol       :vec4}
   :state    {:depth-test true}})
