(ns thi.ng.geom.webgl.animator)

(def animframe-provider
  (or
   (.-requestAnimationFrame js/window)
   (.-webkitRequestAnimationFrame js/window)
   (.-mozRequestAnimationFrame js/window)
   (.-msRequestAnimationFrame js/window)
   (.-oRequestAnimationFrame js/window)))

(defn now
  []
  (or
   (.now js/performance)
   (.webkitNow js/performance)
   (.mozNow js/performance)
   (.msNow js/performance)
   (.oNow js/performance)))

(defn animate
  ([f]
   (animate f nil))
  ([f element]
   (let [t0  (.getTime (js/Date.))
         fid (volatile! 0)
         f'  (fn animate* []
               (if (f (* (- (.getTime (js/Date.)) t0) 1e-3) (vswap! fid inc))
                 (if element
                   (animframe-provider animate* element)
                   (animframe-provider animate*))))]
     (f'))))
