(ns thi.ng.macromath.core)

(defmacro defmathop
  "Constructs macro to build inlined nested expressions with f applied
  successively. Supports arities 2-8."
  [name f]
  `(defmacro ~name
     ([a# b#]
        `(~~f ~a# ~b#))
     ([a# b# c#]
        `(~~f (~~f ~a# ~b#) ~c#))
     ([a# b# c# d#]
        `(~~f (~~f (~~f ~a# ~b#) ~c#) ~d#))
     ([a# b# c# d# e#]
        `(~~f (~~f (~~f (~~f ~a# ~b#) ~c#) ~d#) ~e#))
     ([a# b# c# d# e# f#]
        `(~~f (~~f (~~f (~~f (~~f ~a# ~b#) ~c#) ~d#) ~e#) ~f#))
     ([a# b# c# d# e# f# g#]
        `(~~f (~~f (~~f (~~f (~~f (~~f ~a# ~b#) ~c#) ~d#) ~e#) ~f#) ~g#))
     ([a# b# c# d# e# f# g# h#]
        `(~~f (~~f (~~f (~~f (~~f (~~f (~~f ~a# ~b#) ~c#) ~d#) ~e#) ~f#) ~g#) ~h#))))

(defmacro defmathop2
  "Constructs macro to build inlined nested expressions with f applied
  to inner pairs and f2 to combine results."
  [name f f2]
  `(defmacro ~name
     ([a# b# c#]
        `(~~f2 (~~f ~a# ~b#) ~c#))
     ([a# b# c# d#]
        `(~~f2 (~~f ~a# ~b#) (~~f ~c# ~d#)))
     ([a# b# c# d# e#]
        `(~~f2 (~~f2 (~~f ~a# ~b#) (~~f ~c# ~d#)) ~e#))
     ([a# b# c# d# e# f#]
        `(~~f2 (~~f2 (~~f ~a# ~b#) (~~f ~c# ~d#)) (~~f ~e# ~f#)))
     ([a# b# c# d# e# f# g#]
        `(~~f2 (~~f2 (~~f2 (~~f ~a# ~b#) (~~f ~c# ~d#)) (~~f ~e# ~f#)) ~g#))
     ([a# b# c# d# e# f# g# h#]
        `(~~f2 (~~f2 (~~f2 (~~f ~a# ~b#) (~~f ~c# ~d#)) (~~f ~e# ~f#)) (~~f ~g# ~h#)))))

(defmacro defmathop3
  "Takes f, f2 & f3 as syntax-quoted symbols. Constructs a macro which
  when called, applies f to all but the last 1 or 2 args. The
  remaining arg(s) are combined with the first result using f2.
  Furthermore, for arities 6 and 8, f3 is first applied to the last
  two args are before the final application of f2. For example:

      (defmathop* maddsub `madd `- `*)
      (maddsub 2 3 4 5) => (- (madd 2 3 4) 5)
      (maddsub 2 3 4 5 6) => (- (madd 2 3 4) (* 5 6))"
  [name f f2 f3]
  `(defmacro ~name
     ([a# b# c# d#]
        `(~~f2 (~~f ~a# ~b# ~c#) ~d#))
     ([a# b# c# d# e#]
        `(~~f2 (~~f ~a# ~b# ~c# ~d#) ~e#))
     ([a# b# c# d# e# f#]
        `(~~f2 (~~f ~a# ~b# ~c# ~d#) (~~f3 ~e# ~f#)))
     ([a# b# c# d# e# f# g#]
        `(~~f2 (~~f ~a# ~b# ~c# ~d# ~e# ~f#) ~g#))
     ([a# b# c# d# e# f# g# h#]
        `(~~f2 (~~f ~a# ~b# ~c# ~d# ~e# ~f#) (~~f3 ~g# ~h#)))))

(defmathop add `+)
(defmathop sub `-)
(defmathop mul `*)
(defmathop div `/)
(defmathop2 madd `* `+)
(defmathop2 msub `* `-)
(defmathop2 addm `+ `*)
(defmathop2 subm `- `*)
(defmathop2 adddiv `+ `/)
(defmathop2 subdiv `- `/)
(defmathop3 maddsub `madd `- `*)
(defmathop3 addmsub `addm `- `*)
(defmathop3 msubadd `msub `+ `*)
(defmathop3 submadd `subm `+ `*)
