(defproject thi.ng/macromath "0.3.0-SNAPSHOT"
  :description  "Collection of common math macros to produce inline expanded, nested expressions."
  :url          "https://github.com/thi-ng/macromath"
  :license      {:name "Apache Software License 2.0"
                 :url "https://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "git@github.com:thi-ng/macromath.git"}

  :min-lein-vesion "2.4.0"

  :dependencies [[org.clojure/clojure "1.6.0-beta2"]]

  :source-paths ["src/cljx"]
  :test-paths   ["target/test-classes"]

  :profiles     {:dev {:dependencies [[org.clojure/clojurescript "0.0-2173"]
                                      [criterium "0.4.1"]]
                       :plugins [[org.clojars.cemerick/cljx "0.5.0-SNAPSHOT"]
                                 [lein-cljsbuild "1.0.2"]
                                 [com.cemerick/clojurescript.test "0.2.2"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :auto-clean false
                       :prep-tasks [["cljx" "once"] "javac" "compile"]
                       :aliases {"cleantest" ["do" "clean" ["test" ":all"] ["cljsbuild" "test"]]}}}

  :cljx         {:builds [{:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :clj}
                          {:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :cljs}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :clj}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :cljs}]}

  :cljsbuild    {:builds [{:source-paths ["target/classes" "target/test-classes"]
                           :id "simple"
                           :compiler {:output-to "target/macromath-0.3.0-SNAPSHOT.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/macromath-0.3.0-SNAPSHOT.js"]}}

  :pom-addition [:developers [:developer {:id "toxi"}
                              [:name "Karsten Schmidt"]
                              [:url "http://thi.ng"]
                              [:timezone "0"]]])
