(defproject thi.ng/morphogen "0.2.0-SNAPSHOT"
  :description  "3d form evolution through tree-based transformations"
  :url          "https://github.com/thi-ng/morphogen"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "git@github.com:thi-ng/morphogen.git"}

  :min-lein-vesion "2.4.0"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [thi.ng/geom "1.0.0-RC3"]]

  :profiles     {:dev {:dependencies [[thi.ng/luxor "0.3.0" :exclusions [thi.ng/common thi.ng/geom]]
                                      [org.clojure/clojurescript "1.10.238"]
                                      [criterium "0.4.3"]]
                       :plugins [[lein-cljsbuild "1.1.7"]
                                 [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean" "test" "cljsbuild" "test"]}}}

  :cljsbuild    {:builds [{:source-paths ["src" "test"]
                           :id "simple"
                           :compiler {:output-to "target/morphogen-0.2.0-SNAPSHOT.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/morphogen-0.2.0-SNAPSHOT.js"]}}

  :pom-addition [:developers [:developer
                                [:name "Karsten Schmidt"]
                                [:url "http://postspectacular.com"]
                                [:timezone "0"]]])
