(ns thi.ng.sema.query.resultio
  (:require
   [thi.ng.sema.core.api :as api]
   [thi.ng.sema.common.util :as util]
   [thi.ng.sema.query.executor :as q]
   [thi.ng.common.data.core :as d]
   [clojure.string :as str]
                                   
                                     
                                  ))

(defn result-value
  [x]
  (if (satisfies? api/PNode x) (api/label x) x))

     
               
                                         
                   
                                       
                                          
                                                      
                                                             
                                                                                                   
                                                                      
                            
                                                                                    
                                        
                                                                   

(defn result-value-json
  [x {:keys [datatypes]}]
  (if (satisfies? api/PNode x)
    (let [label (api/label x)
          res {:value label}]
      (if (api/literal? x)
        (let [res (assoc res :type "literal")]
          (if-let [lang (api/language x)]
            (assoc res :xml:lang lang)
            (if-let [dt (and datatypes (api/datatype x))]
              (assoc res :datatype dt)
              (assoc res :value (api/literal-value x)))))
        (if (api/uri? x)
          (assoc res :type "uri")
          (assoc res :type "bnode"))))
    {:type "literal" :value x}))

(defn result-binding-json
  [vmap bindings opts]
  (->> bindings
       (map (fn [[k v]] [(vmap k) (result-value-json v opts)]))
       (into {})))

     
                
                                          
                                
                               
                                                                              
                       
                                                      
                                         
                                                                                       
                                                        
          

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/sema/query/resultio.cljx
