(ns thi.ng.glsl.core
  (:require
   [clojure.string :as str]))

(defn- minify-line
  [src]
  (let [src (-> src
                (str/replace #"\s{2,}|\t" "")
                (str/replace #"\s*(\{|\}|\=|\*|\,|\+|/|\>|\<|\&|\||\[|\]|\(|\)|\-|\!|\;)\s*" "$1"))]
    (if (= \# (first src))
      (str "\n" src "\n")
      src)))

(defn- clean-line-breaks
  [src] (str/replace src #"\n{2,}" "\n"))

(defn minify
  [src]
  (let [src (-> src
                (str/replace #"//.*" "")
                (str/replace #"/\*[\s\S]*?\*/" "")
                (str/replace #"^\n+" ""))]
    (->> (str/split src #"\n")
         (map minify-line)
         (apply str)
         (clean-line-breaks))))

(defmacro minified
  [src] `~(minify src))

(defmacro glsl-spec
  [deps src] `{:deps ~deps :src (minified ~src)})

(defmacro glsl-file-spec
  [deps path] `{:deps ~deps :src (minified ~(slurp path))})

(defmacro defglsl
  [name deps src]
  `(def ~name (glsl-spec ~deps ~src)))

(defmacro defglsl-file
  [name deps path]
  `(def ~name (glsl-file-spec ~deps ~path)))
