(ns thi.ng.glsl.core
  (:require
   [clojure.string :as str]
   [com.stuartsierra.dependency :as dep]))

(defn- minify-line
  [src]
  (let [src (-> src
                (str/replace #"\s{2,}|\t" "")
                (str/replace #"\s*(\{|\}|\=|\*|\,|\+|/|\>|\<|\&|\||\[|\]|\(|\)|\-|\!|\;)\s*" "$1"))]
    (if (= \# (first src))
      (str "\n" src "\n")
      src)))

(defn- clean-line-breaks
  [src] (str/replace src #"\n{2,}" "\n"))

(defn minify
  [src]
  (let [src (-> src
                (str/replace #"//.*" "")
                (str/replace #"/\*[\s\S]*?\*/" "")
                (str/replace #"^\n+" ""))]
    (->> (str/split src #"\n")
         (map minify-line)
         (apply str)
         (clean-line-breaks))))

(defn- build-graph
  ([spec] (build-graph (dep/graph) spec))
  ([g curr]
     (reduce
      (fn [g d] (build-graph (dep/depend g curr d) d))
      g (:deps curr))))

(defn assemble
  [spec]
  (if (seq (:deps spec))
    (->> spec
         (build-graph)
         (dep/topo-sort)
         (mapv :src)
         (apply str))
    (:src spec)))

(defn glsl-spec-plain
  [deps src] {:deps deps :src src})
