(defproject thi.ng/shaderlib "0.1.0"
  :description  "WebGL/GLSL shader library & dependency framework for ClojureScript"
  :url          "https://github.com/thi-ng/shaderlib"
  :license      {:name "Apache Software License"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/shaderlib"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2411"]
                 [com.postspectacular/dependency "0.1.2"]]

  :profiles {:dev {:plugins [[lein-cljsbuild "1.0.4-SNAPSHOT"]
                             [com.cemerick/clojurescript.test "0.3.3"]]
                   :aliases {"cleantest" ["do" "clean," "cljsbuild" "test"]}}}

  :cljsbuild {:builds [{:source-paths ["src" "test"]
                        :id "simple"
                        :compiler {:output-to "target/shaderlib-0.1.0.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}
                       {:source-paths ["src" "test"]
                        :id "prod"
                        :compiler {:output-to "target/shaderlib-0.1.0.js"
                                   :optimizations :advanced
                                   :pretty-print false}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/shaderlib-0.1.0.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
