(defproject thi.ng/trio "0.1.0-SNAPSHOT"
  :description  "Generic triple store API & SPARQL-like query engine"
  :url          "http://thi.ng/trio"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "git@github.com:thi-ng/trio.git"}

  :min-lein-vesion "2.4.0"
  
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [thi.ng/common "0.3.0-SNAPSHOT"]
                 [thi.ng/validate "0.1.0-SNAPSHOT"]
                 [org.clojure/data.csv "0.1.2"]
                 [com.taoensso/timbre "3.3.1"]]

  :source-paths ["src/cljx"]
  :test-paths   ["target/test-classes"]

  :profiles     {:dev {:dependencies [[org.clojure/clojurescript "0.0-2322"]
                                      [criterium "0.4.3"]]
                       :plugins [[org.clojars.cemerick/cljx "0.5.0-SNAPSHOT"]
                                 [lein-cljsbuild "1.0.3"]
                                 [com.cemerick/clojurescript.test "0.3.1"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :auto-clean false
                       :prep-tasks [["cljx" "once"] "javac" "compile"]
                       :aliases {"cleantest" ["do" "clean" ["test" ":all"] ["cljsbuild" "test"]]}}}

  :cljx         {:builds [{:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :clj}
                          {:source-paths ["src/cljx"]
                           :output-path "target/classes"
                           :rules :cljs}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :clj}
                          {:source-paths ["test/cljx"]
                           :output-path "target/test-classes"
                           :rules :cljs}]}

  :cljsbuild    {:builds [{:source-paths ["target/classes" "target/test-classes"]
                           :id "simple"
                           :compiler {:output-to "target/trio-0.1.0-SNAPSHOT.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/trio-0.1.0-SNAPSHOT.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
