(defproject thi.ng/typedarrays "0.1.7"
  :description  "CLJS typed arrays functions"
  :url          "http://thi.ng/typedarrays"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "git@github.com:thi-ng/typedarrays.git"}

  :min-lein-vesion "2.4.0"

  :dependencies [[org.clojure/clojure "1.11.1"]
                 [org.clojure/clojurescript "1.11.4"]]

  :profiles     {:dev {:plugins [[lein-cljsbuild "1.1.8"]
                                 [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean," "cljsbuild" "test"]}}}

  :cljsbuild    {:builds [{:id "simple"
                           :source-paths ["src" "test"]
                           :compiler {:output-to "target/typedarrays-0.1.7.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["open" :runner "index.html"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "https://thi.ng"]
                              [:timezone "1"]]])
