// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__40208 = cljs.core._EQ_;
var expr__40209 = (function (){var or__18405__auto__ = (function (){try{return localStorage.getItem("figwheel_autoload");
}catch (e40212){if((e40212 instanceof Error)){
var e = e40212;
return false;
} else {
throw e40212;

}
}})();
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__40208.call(null,"true",expr__40209))){
return true;
} else {
if(cljs.core.truth_(pred__40208.call(null,"false",expr__40209))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__40209)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
try{localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
}catch (e40214){if((e40214 instanceof Error)){
var e = e40214;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Unable to access localStorage")].join(''));
} else {
throw e40214;

}
}} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.repl_print_fn = (function figwheel$client$repl_print_fn(var_args){
var args__19470__auto__ = [];
var len__19463__auto___40216 = arguments.length;
var i__19464__auto___40217 = (0);
while(true){
if((i__19464__auto___40217 < len__19463__auto___40216)){
args__19470__auto__.push((arguments[i__19464__auto___40217]));

var G__40218 = (i__19464__auto___40217 + (1));
i__19464__auto___40217 = G__40218;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((0) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((0)),(0))):null);
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__19471__auto__);
});

figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));

return null;
});

figwheel.client.repl_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_print_fn.cljs$lang$applyTo = (function (seq40215){
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40215));
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__40219){
var map__40222 = p__40219;
var map__40222__$1 = ((((!((map__40222 == null)))?((((map__40222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40222):map__40222);
var message = cljs.core.get.call(null,map__40222__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__40222__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__18405__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18405__auto__)){
return or__18405__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__18393__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__18393__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__18393__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__20558__auto___40384 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___40384,ch){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___40384,ch){
return (function (state_40353){
var state_val_40354 = (state_40353[(1)]);
if((state_val_40354 === (7))){
var inst_40349 = (state_40353[(2)]);
var state_40353__$1 = state_40353;
var statearr_40355_40385 = state_40353__$1;
(statearr_40355_40385[(2)] = inst_40349);

(statearr_40355_40385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (1))){
var state_40353__$1 = state_40353;
var statearr_40356_40386 = state_40353__$1;
(statearr_40356_40386[(2)] = null);

(statearr_40356_40386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (4))){
var inst_40306 = (state_40353[(7)]);
var inst_40306__$1 = (state_40353[(2)]);
var state_40353__$1 = (function (){var statearr_40357 = state_40353;
(statearr_40357[(7)] = inst_40306__$1);

return statearr_40357;
})();
if(cljs.core.truth_(inst_40306__$1)){
var statearr_40358_40387 = state_40353__$1;
(statearr_40358_40387[(1)] = (5));

} else {
var statearr_40359_40388 = state_40353__$1;
(statearr_40359_40388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (15))){
var inst_40313 = (state_40353[(8)]);
var inst_40328 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40313);
var inst_40329 = cljs.core.first.call(null,inst_40328);
var inst_40330 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_40329);
var inst_40331 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_40330)].join('');
var inst_40332 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_40331);
var state_40353__$1 = state_40353;
var statearr_40360_40389 = state_40353__$1;
(statearr_40360_40389[(2)] = inst_40332);

(statearr_40360_40389[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (13))){
var inst_40337 = (state_40353[(2)]);
var state_40353__$1 = state_40353;
var statearr_40361_40390 = state_40353__$1;
(statearr_40361_40390[(2)] = inst_40337);

(statearr_40361_40390[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (6))){
var state_40353__$1 = state_40353;
var statearr_40362_40391 = state_40353__$1;
(statearr_40362_40391[(2)] = null);

(statearr_40362_40391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (17))){
var inst_40335 = (state_40353[(2)]);
var state_40353__$1 = state_40353;
var statearr_40363_40392 = state_40353__$1;
(statearr_40363_40392[(2)] = inst_40335);

(statearr_40363_40392[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (3))){
var inst_40351 = (state_40353[(2)]);
var state_40353__$1 = state_40353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40353__$1,inst_40351);
} else {
if((state_val_40354 === (12))){
var inst_40312 = (state_40353[(9)]);
var inst_40326 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_40312,opts);
var state_40353__$1 = state_40353;
if(cljs.core.truth_(inst_40326)){
var statearr_40364_40393 = state_40353__$1;
(statearr_40364_40393[(1)] = (15));

} else {
var statearr_40365_40394 = state_40353__$1;
(statearr_40365_40394[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (2))){
var state_40353__$1 = state_40353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40353__$1,(4),ch);
} else {
if((state_val_40354 === (11))){
var inst_40313 = (state_40353[(8)]);
var inst_40318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40319 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_40313);
var inst_40320 = cljs.core.async.timeout.call(null,(1000));
var inst_40321 = [inst_40319,inst_40320];
var inst_40322 = (new cljs.core.PersistentVector(null,2,(5),inst_40318,inst_40321,null));
var state_40353__$1 = state_40353;
return cljs.core.async.ioc_alts_BANG_.call(null,state_40353__$1,(14),inst_40322);
} else {
if((state_val_40354 === (9))){
var inst_40313 = (state_40353[(8)]);
var inst_40339 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_40340 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40313);
var inst_40341 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_40340);
var inst_40342 = [cljs.core.str("Not loading: "),cljs.core.str(inst_40341)].join('');
var inst_40343 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_40342);
var state_40353__$1 = (function (){var statearr_40366 = state_40353;
(statearr_40366[(10)] = inst_40339);

return statearr_40366;
})();
var statearr_40367_40395 = state_40353__$1;
(statearr_40367_40395[(2)] = inst_40343);

(statearr_40367_40395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (5))){
var inst_40306 = (state_40353[(7)]);
var inst_40308 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_40309 = (new cljs.core.PersistentArrayMap(null,2,inst_40308,null));
var inst_40310 = (new cljs.core.PersistentHashSet(null,inst_40309,null));
var inst_40311 = figwheel.client.focus_msgs.call(null,inst_40310,inst_40306);
var inst_40312 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_40311);
var inst_40313 = cljs.core.first.call(null,inst_40311);
var inst_40314 = figwheel.client.autoload_QMARK_.call(null);
var state_40353__$1 = (function (){var statearr_40368 = state_40353;
(statearr_40368[(8)] = inst_40313);

(statearr_40368[(9)] = inst_40312);

return statearr_40368;
})();
if(cljs.core.truth_(inst_40314)){
var statearr_40369_40396 = state_40353__$1;
(statearr_40369_40396[(1)] = (8));

} else {
var statearr_40370_40397 = state_40353__$1;
(statearr_40370_40397[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (14))){
var inst_40324 = (state_40353[(2)]);
var state_40353__$1 = state_40353;
var statearr_40371_40398 = state_40353__$1;
(statearr_40371_40398[(2)] = inst_40324);

(statearr_40371_40398[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (16))){
var state_40353__$1 = state_40353;
var statearr_40372_40399 = state_40353__$1;
(statearr_40372_40399[(2)] = null);

(statearr_40372_40399[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (10))){
var inst_40345 = (state_40353[(2)]);
var state_40353__$1 = (function (){var statearr_40373 = state_40353;
(statearr_40373[(11)] = inst_40345);

return statearr_40373;
})();
var statearr_40374_40400 = state_40353__$1;
(statearr_40374_40400[(2)] = null);

(statearr_40374_40400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40354 === (8))){
var inst_40312 = (state_40353[(9)]);
var inst_40316 = figwheel.client.reload_file_state_QMARK_.call(null,inst_40312,opts);
var state_40353__$1 = state_40353;
if(cljs.core.truth_(inst_40316)){
var statearr_40375_40401 = state_40353__$1;
(statearr_40375_40401[(1)] = (11));

} else {
var statearr_40376_40402 = state_40353__$1;
(statearr_40376_40402[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto___40384,ch))
;
return ((function (switch__20446__auto__,c__20558__auto___40384,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_40380 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40380[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__);

(statearr_40380[(1)] = (1));

return statearr_40380;
});
var figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1 = (function (state_40353){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_40353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e40381){if((e40381 instanceof Object)){
var ex__20450__auto__ = e40381;
var statearr_40382_40403 = state_40353;
(statearr_40382_40403[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40404 = state_40353;
state_40353 = G__40404;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__ = function(state_40353){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1.call(this,state_40353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__20447__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___40384,ch))
})();
var state__20560__auto__ = (function (){var statearr_40383 = f__20559__auto__.call(null);
(statearr_40383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___40384);

return statearr_40383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___40384,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__40405_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__40405_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_40412 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_40412){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_40410 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_40411 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),figwheel.client.utils.eval_helper.call(null,code,opts)], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_40411;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_40410;
}}catch (e40409){if((e40409 instanceof Error)){
var e = e40409;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_40412], null));
} else {
var e = e40409;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_40412))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__40413){
var map__40420 = p__40413;
var map__40420__$1 = ((((!((map__40420 == null)))?((((map__40420.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40420.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40420):map__40420);
var opts = map__40420__$1;
var build_id = cljs.core.get.call(null,map__40420__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__40420,map__40420__$1,opts,build_id){
return (function (p__40422){
var vec__40423 = p__40422;
var map__40424 = cljs.core.nth.call(null,vec__40423,(0),null);
var map__40424__$1 = ((((!((map__40424 == null)))?((((map__40424.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40424.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40424):map__40424);
var msg = map__40424__$1;
var msg_name = cljs.core.get.call(null,map__40424__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__40423,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__40423,map__40424,map__40424__$1,msg,msg_name,_,map__40420,map__40420__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__40423,map__40424,map__40424__$1,msg,msg_name,_,map__40420,map__40420__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__40420,map__40420__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__40430){
var vec__40431 = p__40430;
var map__40432 = cljs.core.nth.call(null,vec__40431,(0),null);
var map__40432__$1 = ((((!((map__40432 == null)))?((((map__40432.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40432.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40432):map__40432);
var msg = map__40432__$1;
var msg_name = cljs.core.get.call(null,map__40432__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__40431,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__40434){
var map__40444 = p__40434;
var map__40444__$1 = ((((!((map__40444 == null)))?((((map__40444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40444):map__40444);
var on_compile_warning = cljs.core.get.call(null,map__40444__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__40444__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__40444,map__40444__$1,on_compile_warning,on_compile_fail){
return (function (p__40446){
var vec__40447 = p__40446;
var map__40448 = cljs.core.nth.call(null,vec__40447,(0),null);
var map__40448__$1 = ((((!((map__40448 == null)))?((((map__40448.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40448.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40448):map__40448);
var msg = map__40448__$1;
var msg_name = cljs.core.get.call(null,map__40448__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__40447,(1));
var pred__40450 = cljs.core._EQ_;
var expr__40451 = msg_name;
if(cljs.core.truth_(pred__40450.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__40451))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__40450.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__40451))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__40444,map__40444__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__,msg_hist,msg_names,msg){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__,msg_hist,msg_names,msg){
return (function (state_40667){
var state_val_40668 = (state_40667[(1)]);
if((state_val_40668 === (7))){
var inst_40591 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40591)){
var statearr_40669_40715 = state_40667__$1;
(statearr_40669_40715[(1)] = (8));

} else {
var statearr_40670_40716 = state_40667__$1;
(statearr_40670_40716[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (20))){
var inst_40661 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40671_40717 = state_40667__$1;
(statearr_40671_40717[(2)] = inst_40661);

(statearr_40671_40717[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (27))){
var inst_40657 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40672_40718 = state_40667__$1;
(statearr_40672_40718[(2)] = inst_40657);

(statearr_40672_40718[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (1))){
var inst_40584 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40584)){
var statearr_40673_40719 = state_40667__$1;
(statearr_40673_40719[(1)] = (2));

} else {
var statearr_40674_40720 = state_40667__$1;
(statearr_40674_40720[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (24))){
var inst_40659 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40675_40721 = state_40667__$1;
(statearr_40675_40721[(2)] = inst_40659);

(statearr_40675_40721[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (4))){
var inst_40665 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40667__$1,inst_40665);
} else {
if((state_val_40668 === (15))){
var inst_40663 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40676_40722 = state_40667__$1;
(statearr_40676_40722[(2)] = inst_40663);

(statearr_40676_40722[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (21))){
var inst_40622 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40677_40723 = state_40667__$1;
(statearr_40677_40723[(2)] = inst_40622);

(statearr_40677_40723[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (31))){
var inst_40646 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40646)){
var statearr_40678_40724 = state_40667__$1;
(statearr_40678_40724[(1)] = (34));

} else {
var statearr_40679_40725 = state_40667__$1;
(statearr_40679_40725[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (32))){
var inst_40655 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40680_40726 = state_40667__$1;
(statearr_40680_40726[(2)] = inst_40655);

(statearr_40680_40726[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (33))){
var inst_40644 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40681_40727 = state_40667__$1;
(statearr_40681_40727[(2)] = inst_40644);

(statearr_40681_40727[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (13))){
var inst_40605 = figwheel.client.heads_up.clear.call(null);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(16),inst_40605);
} else {
if((state_val_40668 === (22))){
var inst_40626 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40627 = figwheel.client.heads_up.append_message.call(null,inst_40626);
var state_40667__$1 = state_40667;
var statearr_40682_40728 = state_40667__$1;
(statearr_40682_40728[(2)] = inst_40627);

(statearr_40682_40728[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (36))){
var inst_40653 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40683_40729 = state_40667__$1;
(statearr_40683_40729[(2)] = inst_40653);

(statearr_40683_40729[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (29))){
var inst_40637 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40684_40730 = state_40667__$1;
(statearr_40684_40730[(2)] = inst_40637);

(statearr_40684_40730[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (6))){
var inst_40586 = (state_40667[(7)]);
var state_40667__$1 = state_40667;
var statearr_40685_40731 = state_40667__$1;
(statearr_40685_40731[(2)] = inst_40586);

(statearr_40685_40731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (28))){
var inst_40633 = (state_40667[(2)]);
var inst_40634 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40635 = figwheel.client.heads_up.display_warning.call(null,inst_40634);
var state_40667__$1 = (function (){var statearr_40686 = state_40667;
(statearr_40686[(8)] = inst_40633);

return statearr_40686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(29),inst_40635);
} else {
if((state_val_40668 === (25))){
var inst_40631 = figwheel.client.heads_up.clear.call(null);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(28),inst_40631);
} else {
if((state_val_40668 === (34))){
var inst_40648 = figwheel.client.heads_up.flash_loaded.call(null);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(37),inst_40648);
} else {
if((state_val_40668 === (17))){
var inst_40613 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40687_40732 = state_40667__$1;
(statearr_40687_40732[(2)] = inst_40613);

(statearr_40687_40732[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (3))){
var inst_40603 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40603)){
var statearr_40688_40733 = state_40667__$1;
(statearr_40688_40733[(1)] = (13));

} else {
var statearr_40689_40734 = state_40667__$1;
(statearr_40689_40734[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (12))){
var inst_40599 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40690_40735 = state_40667__$1;
(statearr_40690_40735[(2)] = inst_40599);

(statearr_40690_40735[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (2))){
var inst_40586 = (state_40667[(7)]);
var inst_40586__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_40667__$1 = (function (){var statearr_40691 = state_40667;
(statearr_40691[(7)] = inst_40586__$1);

return statearr_40691;
})();
if(cljs.core.truth_(inst_40586__$1)){
var statearr_40692_40736 = state_40667__$1;
(statearr_40692_40736[(1)] = (5));

} else {
var statearr_40693_40737 = state_40667__$1;
(statearr_40693_40737[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (23))){
var inst_40629 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40629)){
var statearr_40694_40738 = state_40667__$1;
(statearr_40694_40738[(1)] = (25));

} else {
var statearr_40695_40739 = state_40667__$1;
(statearr_40695_40739[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (35))){
var state_40667__$1 = state_40667;
var statearr_40696_40740 = state_40667__$1;
(statearr_40696_40740[(2)] = null);

(statearr_40696_40740[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (19))){
var inst_40624 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40624)){
var statearr_40697_40741 = state_40667__$1;
(statearr_40697_40741[(1)] = (22));

} else {
var statearr_40698_40742 = state_40667__$1;
(statearr_40698_40742[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (11))){
var inst_40595 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40699_40743 = state_40667__$1;
(statearr_40699_40743[(2)] = inst_40595);

(statearr_40699_40743[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (9))){
var inst_40597 = figwheel.client.heads_up.clear.call(null);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(12),inst_40597);
} else {
if((state_val_40668 === (5))){
var inst_40588 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_40667__$1 = state_40667;
var statearr_40700_40744 = state_40667__$1;
(statearr_40700_40744[(2)] = inst_40588);

(statearr_40700_40744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (14))){
var inst_40615 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40615)){
var statearr_40701_40745 = state_40667__$1;
(statearr_40701_40745[(1)] = (18));

} else {
var statearr_40702_40746 = state_40667__$1;
(statearr_40702_40746[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (26))){
var inst_40639 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40639)){
var statearr_40703_40747 = state_40667__$1;
(statearr_40703_40747[(1)] = (30));

} else {
var statearr_40704_40748 = state_40667__$1;
(statearr_40704_40748[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (16))){
var inst_40607 = (state_40667[(2)]);
var inst_40608 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40609 = figwheel.client.format_messages.call(null,inst_40608);
var inst_40610 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40611 = figwheel.client.heads_up.display_error.call(null,inst_40609,inst_40610);
var state_40667__$1 = (function (){var statearr_40705 = state_40667;
(statearr_40705[(9)] = inst_40607);

return statearr_40705;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(17),inst_40611);
} else {
if((state_val_40668 === (30))){
var inst_40641 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40642 = figwheel.client.heads_up.display_warning.call(null,inst_40641);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(33),inst_40642);
} else {
if((state_val_40668 === (10))){
var inst_40601 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40706_40749 = state_40667__$1;
(statearr_40706_40749[(2)] = inst_40601);

(statearr_40706_40749[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (18))){
var inst_40617 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40618 = figwheel.client.format_messages.call(null,inst_40617);
var inst_40619 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40620 = figwheel.client.heads_up.display_error.call(null,inst_40618,inst_40619);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(21),inst_40620);
} else {
if((state_val_40668 === (37))){
var inst_40650 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40707_40750 = state_40667__$1;
(statearr_40707_40750[(2)] = inst_40650);

(statearr_40707_40750[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (8))){
var inst_40593 = figwheel.client.heads_up.flash_loaded.call(null);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40667__$1,(11),inst_40593);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20558__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__20446__auto__,c__20558__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0 = (function (){
var statearr_40711 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40711[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__);

(statearr_40711[(1)] = (1));

return statearr_40711;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1 = (function (state_40667){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_40667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e40712){if((e40712 instanceof Object)){
var ex__20450__auto__ = e40712;
var statearr_40713_40751 = state_40667;
(statearr_40713_40751[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40752 = state_40667;
state_40667 = G__40752;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__ = function(state_40667){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1.call(this,state_40667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__,msg_hist,msg_names,msg))
})();
var state__20560__auto__ = (function (){var statearr_40714 = f__20559__auto__.call(null);
(statearr_40714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_40714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__,msg_hist,msg_names,msg))
);

return c__20558__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__20558__auto___40815 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto___40815,ch){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto___40815,ch){
return (function (state_40798){
var state_val_40799 = (state_40798[(1)]);
if((state_val_40799 === (1))){
var state_40798__$1 = state_40798;
var statearr_40800_40816 = state_40798__$1;
(statearr_40800_40816[(2)] = null);

(statearr_40800_40816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40799 === (2))){
var state_40798__$1 = state_40798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40798__$1,(4),ch);
} else {
if((state_val_40799 === (3))){
var inst_40796 = (state_40798[(2)]);
var state_40798__$1 = state_40798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40798__$1,inst_40796);
} else {
if((state_val_40799 === (4))){
var inst_40786 = (state_40798[(7)]);
var inst_40786__$1 = (state_40798[(2)]);
var state_40798__$1 = (function (){var statearr_40801 = state_40798;
(statearr_40801[(7)] = inst_40786__$1);

return statearr_40801;
})();
if(cljs.core.truth_(inst_40786__$1)){
var statearr_40802_40817 = state_40798__$1;
(statearr_40802_40817[(1)] = (5));

} else {
var statearr_40803_40818 = state_40798__$1;
(statearr_40803_40818[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40799 === (5))){
var inst_40786 = (state_40798[(7)]);
var inst_40788 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_40786);
var state_40798__$1 = state_40798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40798__$1,(8),inst_40788);
} else {
if((state_val_40799 === (6))){
var state_40798__$1 = state_40798;
var statearr_40804_40819 = state_40798__$1;
(statearr_40804_40819[(2)] = null);

(statearr_40804_40819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40799 === (7))){
var inst_40794 = (state_40798[(2)]);
var state_40798__$1 = state_40798;
var statearr_40805_40820 = state_40798__$1;
(statearr_40805_40820[(2)] = inst_40794);

(statearr_40805_40820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40799 === (8))){
var inst_40790 = (state_40798[(2)]);
var state_40798__$1 = (function (){var statearr_40806 = state_40798;
(statearr_40806[(8)] = inst_40790);

return statearr_40806;
})();
var statearr_40807_40821 = state_40798__$1;
(statearr_40807_40821[(2)] = null);

(statearr_40807_40821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__20558__auto___40815,ch))
;
return ((function (switch__20446__auto__,c__20558__auto___40815,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_40811 = [null,null,null,null,null,null,null,null,null];
(statearr_40811[(0)] = figwheel$client$heads_up_plugin_$_state_machine__20447__auto__);

(statearr_40811[(1)] = (1));

return statearr_40811;
});
var figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1 = (function (state_40798){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_40798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e40812){if((e40812 instanceof Object)){
var ex__20450__auto__ = e40812;
var statearr_40813_40822 = state_40798;
(statearr_40813_40822[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40823 = state_40798;
state_40798 = G__40823;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__ = function(state_40798){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1.call(this,state_40798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__20447__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__20447__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto___40815,ch))
})();
var state__20560__auto__ = (function (){var statearr_40814 = f__20559__auto__.call(null);
(statearr_40814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto___40815);

return statearr_40814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto___40815,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__20558__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20558__auto__){
return (function (){
var f__20559__auto__ = (function (){var switch__20446__auto__ = ((function (c__20558__auto__){
return (function (state_40844){
var state_val_40845 = (state_40844[(1)]);
if((state_val_40845 === (1))){
var inst_40839 = cljs.core.async.timeout.call(null,(3000));
var state_40844__$1 = state_40844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40844__$1,(2),inst_40839);
} else {
if((state_val_40845 === (2))){
var inst_40841 = (state_40844[(2)]);
var inst_40842 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_40844__$1 = (function (){var statearr_40846 = state_40844;
(statearr_40846[(7)] = inst_40841);

return statearr_40846;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40844__$1,inst_40842);
} else {
return null;
}
}
});})(c__20558__auto__))
;
return ((function (switch__20446__auto__,c__20558__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0 = (function (){
var statearr_40850 = [null,null,null,null,null,null,null,null];
(statearr_40850[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__);

(statearr_40850[(1)] = (1));

return statearr_40850;
});
var figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1 = (function (state_40844){
while(true){
var ret_value__20448__auto__ = (function (){try{while(true){
var result__20449__auto__ = switch__20446__auto__.call(null,state_40844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20449__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20449__auto__;
}
break;
}
}catch (e40851){if((e40851 instanceof Object)){
var ex__20450__auto__ = e40851;
var statearr_40852_40854 = state_40844;
(statearr_40852_40854[(5)] = ex__20450__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40844);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40851;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20448__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40855 = state_40844;
state_40844 = G__40855;
continue;
} else {
return ret_value__20448__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__ = function(state_40844){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1.call(this,state_40844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__20447__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__20447__auto__;
})()
;})(switch__20446__auto__,c__20558__auto__))
})();
var state__20560__auto__ = (function (){var statearr_40853 = f__20559__auto__.call(null);
(statearr_40853[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20558__auto__);

return statearr_40853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20560__auto__);
});})(c__20558__auto__))
);

return c__20558__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__40856){
var map__40863 = p__40856;
var map__40863__$1 = ((((!((map__40863 == null)))?((((map__40863.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40863.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40863):map__40863);
var ed = map__40863__$1;
var formatted_exception = cljs.core.get.call(null,map__40863__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__40863__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__40863__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__40865_40869 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__40866_40870 = null;
var count__40867_40871 = (0);
var i__40868_40872 = (0);
while(true){
if((i__40868_40872 < count__40867_40871)){
var msg_40873 = cljs.core._nth.call(null,chunk__40866_40870,i__40868_40872);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_40873);

var G__40874 = seq__40865_40869;
var G__40875 = chunk__40866_40870;
var G__40876 = count__40867_40871;
var G__40877 = (i__40868_40872 + (1));
seq__40865_40869 = G__40874;
chunk__40866_40870 = G__40875;
count__40867_40871 = G__40876;
i__40868_40872 = G__40877;
continue;
} else {
var temp__4657__auto___40878 = cljs.core.seq.call(null,seq__40865_40869);
if(temp__4657__auto___40878){
var seq__40865_40879__$1 = temp__4657__auto___40878;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40865_40879__$1)){
var c__19208__auto___40880 = cljs.core.chunk_first.call(null,seq__40865_40879__$1);
var G__40881 = cljs.core.chunk_rest.call(null,seq__40865_40879__$1);
var G__40882 = c__19208__auto___40880;
var G__40883 = cljs.core.count.call(null,c__19208__auto___40880);
var G__40884 = (0);
seq__40865_40869 = G__40881;
chunk__40866_40870 = G__40882;
count__40867_40871 = G__40883;
i__40868_40872 = G__40884;
continue;
} else {
var msg_40885 = cljs.core.first.call(null,seq__40865_40879__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_40885);

var G__40886 = cljs.core.next.call(null,seq__40865_40879__$1);
var G__40887 = null;
var G__40888 = (0);
var G__40889 = (0);
seq__40865_40869 = G__40886;
chunk__40866_40870 = G__40887;
count__40867_40871 = G__40888;
i__40868_40872 = G__40889;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__40890){
var map__40893 = p__40890;
var map__40893__$1 = ((((!((map__40893 == null)))?((((map__40893.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40893.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40893):map__40893);
var w = map__40893__$1;
var message = cljs.core.get.call(null,map__40893__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__18393__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__18393__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__18393__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__40901 = cljs.core.seq.call(null,plugins);
var chunk__40902 = null;
var count__40903 = (0);
var i__40904 = (0);
while(true){
if((i__40904 < count__40903)){
var vec__40905 = cljs.core._nth.call(null,chunk__40902,i__40904);
var k = cljs.core.nth.call(null,vec__40905,(0),null);
var plugin = cljs.core.nth.call(null,vec__40905,(1),null);
if(cljs.core.truth_(plugin)){
var pl_40907 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__40901,chunk__40902,count__40903,i__40904,pl_40907,vec__40905,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_40907.call(null,msg_hist);
});})(seq__40901,chunk__40902,count__40903,i__40904,pl_40907,vec__40905,k,plugin))
);
} else {
}

var G__40908 = seq__40901;
var G__40909 = chunk__40902;
var G__40910 = count__40903;
var G__40911 = (i__40904 + (1));
seq__40901 = G__40908;
chunk__40902 = G__40909;
count__40903 = G__40910;
i__40904 = G__40911;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__40901);
if(temp__4657__auto__){
var seq__40901__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40901__$1)){
var c__19208__auto__ = cljs.core.chunk_first.call(null,seq__40901__$1);
var G__40912 = cljs.core.chunk_rest.call(null,seq__40901__$1);
var G__40913 = c__19208__auto__;
var G__40914 = cljs.core.count.call(null,c__19208__auto__);
var G__40915 = (0);
seq__40901 = G__40912;
chunk__40902 = G__40913;
count__40903 = G__40914;
i__40904 = G__40915;
continue;
} else {
var vec__40906 = cljs.core.first.call(null,seq__40901__$1);
var k = cljs.core.nth.call(null,vec__40906,(0),null);
var plugin = cljs.core.nth.call(null,vec__40906,(1),null);
if(cljs.core.truth_(plugin)){
var pl_40916 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__40901,chunk__40902,count__40903,i__40904,pl_40916,vec__40906,k,plugin,seq__40901__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_40916.call(null,msg_hist);
});})(seq__40901,chunk__40902,count__40903,i__40904,pl_40916,vec__40906,k,plugin,seq__40901__$1,temp__4657__auto__))
);
} else {
}

var G__40917 = cljs.core.next.call(null,seq__40901__$1);
var G__40918 = null;
var G__40919 = (0);
var G__40920 = (0);
seq__40901 = G__40917;
chunk__40902 = G__40918;
count__40903 = G__40919;
i__40904 = G__40920;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args40921 = [];
var len__19463__auto___40924 = arguments.length;
var i__19464__auto___40925 = (0);
while(true){
if((i__19464__auto___40925 < len__19463__auto___40924)){
args40921.push((arguments[i__19464__auto___40925]));

var G__40926 = (i__19464__auto___40925 + (1));
i__19464__auto___40925 = G__40926;
continue;
} else {
}
break;
}

var G__40923 = args40921.length;
switch (G__40923) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40921.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__19470__auto__ = [];
var len__19463__auto___40932 = arguments.length;
var i__19464__auto___40933 = (0);
while(true){
if((i__19464__auto___40933 < len__19463__auto___40932)){
args__19470__auto__.push((arguments[i__19464__auto___40933]));

var G__40934 = (i__19464__auto___40933 + (1));
i__19464__auto___40933 = G__40934;
continue;
} else {
}
break;
}

var argseq__19471__auto__ = ((((0) < args__19470__auto__.length))?(new cljs.core.IndexedSeq(args__19470__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__19471__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__40929){
var map__40930 = p__40929;
var map__40930__$1 = ((((!((map__40930 == null)))?((((map__40930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40930):map__40930);
var opts = map__40930__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq40928){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40928));
});

//# sourceMappingURL=client.js.map