/*
 * Decompiled with CFR 0.152.
 */
package cortex.loss;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.LockingTransaction;
import clojure.lang.MultiFn;
import clojure.lang.Namespace;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import cortex.loss.core$average_loss;
import cortex.loss.core$censor_loss;
import cortex.loss.core$center_loss;
import cortex.loss.core$fn__21470;
import cortex.loss.core$fn__21486;
import cortex.loss.core$fn__21492;
import cortex.loss.core$fn__21497;
import cortex.loss.core$generate_loss_function;
import cortex.loss.core$get_loss_lambda;
import cortex.loss.core$get_loss_term_args_of_type;
import cortex.loss.core$get_loss_term_arguments;
import cortex.loss.core$get_loss_term_augmented_streams;
import cortex.loss.core$get_loss_term_node_outputs;
import cortex.loss.core$get_loss_term_node_parameters;
import cortex.loss.core$get_loss_term_parameters;
import cortex.loss.core$get_loss_term_streams;
import cortex.loss.core$is_loss_node_QMARK_;
import cortex.loss.core$l1_regularization;
import cortex.loss.core$l2_regularization;
import cortex.loss.core$loading__6254__auto____21468;
import cortex.loss.core$loss_fn__GT_table_str;
import cortex.loss.core$loss_metadata;
import cortex.loss.core$loss_term_from_map_key_val;
import cortex.loss.core$mse_loss;
import cortex.loss.core$softmax_loss;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class core__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__3;
    public static final AFn const__4;
    public static final Var const__5;
    public static final AFn const__13;
    public static final Var const__14;
    public static final AFn const__17;
    public static final Var const__18;
    public static final AFn const__21;
    public static final Var const__22;
    public static final AFn const__25;
    public static final Var const__26;
    public static final AFn const__29;
    public static final Var const__30;
    public static final AFn const__33;
    public static final Var const__34;
    public static final AFn const__37;
    public static final Var const__38;
    public static final AFn const__41;
    public static final Var const__42;
    public static final AFn const__45;
    public static final Var const__46;
    public static final AFn const__49;
    public static final Var const__50;
    public static final Keyword const__51;
    public static final Var const__52;
    public static final AFn const__55;
    public static final Var const__56;
    public static final AFn const__59;
    public static final Var const__60;
    public static final AFn const__63;
    public static final Var const__64;
    public static final AFn const__67;
    public static final Var const__68;
    public static final AFn const__71;
    public static final Var const__72;
    public static final AFn const__75;
    public static final Var const__76;
    public static final AFn const__79;
    public static final Var const__80;
    public static final AFn const__83;
    public static final Var const__84;
    public static final AFn const__87;
    public static final Var const__88;
    public static final AFn const__91;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__3);
        Object object2 = ((IFn)new core$loading__6254__auto____21468()).invoke();
        if (((Symbol)const__1).equals((Object)const__4)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new core$fn__21470())));
            v3 = null;
        }
        Var var = const__5;
        var.setMeta((IPersistentMap)const__13);
        Var var2 = var;
        var.bindRoot((Object)new core$loss_metadata());
        Var var3 = const__14;
        var3.setMeta((IPersistentMap)const__17);
        Var var4 = var3;
        var3.bindRoot((Object)new core$is_loss_node_QMARK_());
        Var var5 = const__18;
        var5.setMeta((IPersistentMap)const__21);
        Var var6 = var5;
        var5.bindRoot((Object)new core$get_loss_lambda());
        Var var7 = const__22;
        var7.setMeta((IPersistentMap)const__25);
        Var var8 = var7;
        var7.bindRoot((Object)new core$get_loss_term_arguments());
        Var var9 = const__26;
        var9.setMeta((IPersistentMap)const__29);
        Var var10 = var9;
        var9.bindRoot((Object)new core$get_loss_term_args_of_type());
        Var var11 = const__30;
        var11.setMeta((IPersistentMap)const__33);
        Var var12 = var11;
        var11.bindRoot((Object)new core$get_loss_term_parameters());
        Var var13 = const__34;
        var13.setMeta((IPersistentMap)const__37);
        Var var14 = var13;
        var13.bindRoot((Object)new core$get_loss_term_node_outputs());
        Var var15 = const__38;
        var15.setMeta((IPersistentMap)const__41);
        Var var16 = var15;
        var15.bindRoot((Object)new core$get_loss_term_node_parameters());
        Var var17 = const__42;
        var17.setMeta((IPersistentMap)const__45);
        Var var18 = var17;
        var17.bindRoot((Object)new core$get_loss_term_streams());
        Var var19 = const__46;
        var19.setMeta((IPersistentMap)const__49);
        Var var20 = var19;
        var19.bindRoot((Object)new core$get_loss_term_augmented_streams());
        Object object3 = ((IFn)new core$fn__21486()).invoke();
        MultiFn multiFn = ((MultiFn)const__50.getRawRoot()).addMethod((Object)const__51, (IFn)new core$fn__21492());
        Var var21 = const__52;
        var21.setMeta((IPersistentMap)const__55);
        Var var22 = var21;
        var21.bindRoot((Object)new core$loss_term_from_map_key_val());
        Object object4 = ((IFn)new core$fn__21497()).invoke();
        Var var23 = const__56;
        var23.setMeta((IPersistentMap)const__59);
        Var var24 = var23;
        var23.bindRoot((Object)new core$average_loss());
        Var var25 = const__60;
        var25.setMeta((IPersistentMap)const__63);
        Var var26 = var25;
        var25.bindRoot((Object)new core$mse_loss());
        Var var27 = const__64;
        var27.setMeta((IPersistentMap)const__67);
        Var var28 = var27;
        var27.bindRoot((Object)new core$l1_regularization());
        Var var29 = const__68;
        var29.setMeta((IPersistentMap)const__71);
        Var var30 = var29;
        var29.bindRoot((Object)new core$l2_regularization());
        Var var31 = const__72;
        var31.setMeta((IPersistentMap)const__75);
        Var var32 = var31;
        var31.bindRoot((Object)new core$censor_loss());
        Var var33 = const__76;
        var33.setMeta((IPersistentMap)const__79);
        Var var34 = var33;
        var33.bindRoot((Object)new core$center_loss());
        Var var35 = const__80;
        var35.setMeta((IPersistentMap)const__83);
        Var var36 = var35;
        var35.bindRoot((Object)new core$softmax_loss());
        Var var37 = const__84;
        var37.setMeta((IPersistentMap)const__87);
        Var var38 = var37;
        var37.bindRoot((Object)new core$loss_fn__GT_table_str());
        Var var39 = const__88;
        var39.setMeta((IPersistentMap)const__91);
        Var var40 = var39;
        var39.bindRoot((Object)new core$generate_loss_function());
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"cortex.loss.core")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Definitions and implementations of cortex loss function terms.  A loss term is a function\nthat takes a map of arguments and returns a single double number.  The loss function for a\nnetwork is a weighted summation across a vector of terms.  The weight on any term is :lambda\nand is defined with a per-term-default in the loss metadata for that function type.  The\ndefault is 1.\n\nThe loss terms can have any number of uniquely named arguments and each argument can bind to\none of four different things.\n1.  A node output\n2.  A node parameter\n3.  A stream\n4.  Data tracked by the implementation with an initializer.\n5. An augmented stream.  A pure transformation from a source stream to another stream.\n\nThe loss term can state which of it's arguments it produces gradients for when asked to produce\ngradients. This makes it a little easier for implementations to manage gradients when\nevaluating loss terms."}));
        const__3 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Definitions and implementations of cortex loss function terms.  A loss term is a function\nthat takes a map of arguments and returns a single double number.  The loss function for a\nnetwork is a weighted summation across a vector of terms.  The weight on any term is :lambda\nand is defined with a per-term-default in the loss metadata for that function type.  The\ndefault is 1.\n\nThe loss terms can have any number of uniquely named arguments and each argument can bind to\none of four different things.\n1.  A node output\n2.  A node parameter\n3.  A stream\n4.  Data tracked by the implementation with an initializer.\n5. An augmented stream.  A pure transformation from a source stream to another stream.\n\nThe loss term can state which of it's arguments it produces gradients for when asked to produce\ngradients. This makes it a little easier for implementations to manage gradients when\nevaluating loss terms."});
        const__4 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__5 = RT.var((String)"cortex.loss.core", (String)"loss-metadata");
        const__13 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Get the metadata for a particular loss function.\n\nThere are some standard argument definitions:\n:output - loss-term contains? :node-id output of the node.\n:stream - loss-term contains? :stream the data coming from the data stream.\n:parameter - loss-term contains? :node-id :parameter and this is the value of the parameter of\nthe node.\n\nIn addition loss functions themselves can have parameters in that the network stores in its\ndefinition in parameter buffers.  This is useful in the case where the loss itself has some\nrunning means associated with it like in the form of center loss.\n\nAll losses have a default lambda which weights them against any other elements in the loss.\n\nIn general, the loss function for a given network\n\nThe map must contain:\n{:arguments - The keys and potentially some extra information about the data in the keys passed\nto the loss function.\n  }", RT.keyword(null, (String)"line"), 24, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__14 = RT.var((String)"cortex.loss.core", (String)"is-loss-node?");
        const__17 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"node")))), RT.keyword(null, (String)"line"), 49, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__18 = RT.var((String)"cortex.loss.core", (String)"get-loss-lambda");
        const__21 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"line"), 57, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__22 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-arguments");
        const__25 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Flatten the metadata of the loss term with any specific argument information included\nwith the loss term itself.", RT.keyword(null, (String)"line"), 64, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__26 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-args-of-type");
        const__29 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term"), (Object)Symbol.intern(null, (String)"type")))), RT.keyword(null, (String)"doc"), "Get loss term arguments of a specific type.", RT.keyword(null, (String)"line"), 71, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__30 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-parameters");
        const__33 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "A parameter for a loss term is an argument that has an initialization key.  This means it is\ndata specific to that loss term that will be updated during the term's execution but it also\nneeds to be saved if the network is saved.  Data specific to the loss term that does not need to\nbe saved is expected to be created by the implementation of the term itself.  These are mutually\nexlusive so we should never see a loss term with two or more of them.", RT.keyword(null, (String)"line"), 78, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__34 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-node-outputs");
        const__37 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Get loss term arguments that connect to node outputs.", RT.keyword(null, (String)"line"), 87, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__38 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-node-parameters");
        const__41 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Get loss term arguments that connect to node parameters.", RT.keyword(null, (String)"line"), 92, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__42 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-streams");
        const__45 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Get loss term arguments that connect to data streams.", RT.keyword(null, (String)"line"), 97, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__46 = RT.var((String)"cortex.loss.core", (String)"get-loss-term-augmented-streams");
        const__49 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"doc"), "Loss loss term arguments that are formed from augmented streams of data", RT.keyword(null, (String)"line"), 102, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__50 = RT.var((String)"cortex.loss.core", (String)"generate-loss-term");
        const__51 = RT.keyword(null, (String)"default");
        const__52 = RT.var((String)"cortex.loss.core", (String)"loss-term-from-map-key-val");
        const__55 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"map-key"), (Object)Symbol.intern(null, (String)"loss-val")))), RT.keyword(null, (String)"line"), 120, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__56 = RT.var((String)"cortex.loss.core", (String)"average-loss");
        const__59 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"loss-term"), (Object)Symbol.intern(null, (String)"output-seq"), (Object)Symbol.intern(null, (String)"label-seq"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"double")})))), RT.keyword(null, (String)"doc"), "output is inferences, target is labels.  Calculate the average loss\n  across all inferences and labels.", RT.keyword(null, (String)"line"), 142, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__60 = RT.var((String)"cortex.loss.core", (String)"mse-loss");
        const__63 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"args")))), RT.keyword(null, (String)"doc"), "Mean squared error loss.  Applied to a node and a matching-size output stream.", RT.keyword(null, (String)"line"), 157, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__64 = RT.var((String)"cortex.loss.core", (String)"l1-regularization");
        const__67 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"args")))), RT.keyword(null, (String)"doc"), "Penalize the network for the sum of the absolute values of a given buffer.\nThis pushes all entries of the buffer at a constant rate towards zero and is purported\nto lead to more sparse representations.  This could be applied to either a trainable\nparameter or to a node in which case it will be applied to the node's output buffer.", RT.keyword(null, (String)"line"), 165, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__68 = RT.var((String)"cortex.loss.core", (String)"l2-regularization");
        const__71 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"args")))), RT.keyword(null, (String)"doc"), "Penalize the network for the magnitude of a given buffer.  This will penalize large entries\nin the buffer exponentially more than smaller entries leading to a buffer that tends to produce\nan even distribution of small  entries.  Can be applied to either a trainable parameter or a\nnode in which case it will be applied to the node's output buffer.", RT.keyword(null, (String)"line"), 176, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__72 = RT.var((String)"cortex.loss.core", (String)"censor-loss");
        const__75 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"arg-map")})))), RT.keyword(null, (String)"line"), 187, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__76 = RT.var((String)"cortex.loss.core", (String)"center-loss");
        const__79 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"alpha")), RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"arg-map"), RT.keyword(null, (String)"or"), RT.map((Object[])new Object[]{Symbol.intern(null, (String)"alpha"), 0.5})})))), RT.keyword(null, (String)"doc"), "Center loss is a way of specializing an activation for use as a grouping/sorting\nmechanism.  It groups activations by class and develops centers for the activations\nover the course of training.  Alpha is a number between 1,0 that stands for the exponential\ndecay factor of the running centers (essentially running means).  The equation to update a mean\nis alpha*current + (1 - alpha)*new-mean.  The network is penalized for the distance of the current\nactivations from their respective centers.  The result is that the activation itself becomes very\ngrouped by class and thus make far better candidates for LSH or a distance/sorting system.  Note\nthat this is a loss used in the middle of the graph, not at the edges.  This is applied to a\ngiven node and needs an softmax-type output stream.\nhttp://ydwen.github.io/papers/WenECCV16.pdf", RT.keyword(null, (String)"line"), 193, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__80 = RT.var((String)"cortex.loss.core", (String)"softmax-loss");
        const__83 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"args")))), RT.keyword(null, (String)"doc"), "Softmax loss.  Applied to a node and a softmax (1-hot encoded) output stream.", RT.keyword(null, (String)"line"), 211, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__84 = RT.var((String)"cortex.loss.core", (String)"loss-fn->table-str");
        const__87 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"loss-fn")))), RT.keyword(null, (String)"line"), 219, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
        const__88 = RT.var((String)"cortex.loss.core", (String)"generate-loss-function");
        const__91 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"graph")))), RT.keyword(null, (String)"doc"), "Given a graph with loss terms attached filter the nodes by if they are losses", RT.keyword(null, (String)"line"), 240, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/loss/core.clj"});
    }

    static {
        core__init.__init0();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"cortex.loss.core__init").getClassLoader());
        try {
            core__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

