/*
 * Decompiled with CFR 0.152.
 */
package cortex.nn;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.LockingTransaction;
import clojure.lang.Namespace;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import cortex.nn.traverse$buffer_desc__GT_map_key;
import cortex.nn.traverse$buffer_seq;
import cortex.nn.traverse$clean_traversal;
import cortex.nn.traverse$ensure_unique_buffer_id;
import cortex.nn.traverse$filter_traversal;
import cortex.nn.traverse$fn__39772;
import cortex.nn.traverse$forward_traversal;
import cortex.nn.traverse$generate_traversal_buffer_pools;
import cortex.nn.traverse$get_backward_buffers;
import cortex.nn.traverse$get_forward_buffers;
import cortex.nn.traverse$gradient_loss_function;
import cortex.nn.traverse$graph_node__GT_pass_type;
import cortex.nn.traverse$inference_traversal;
import cortex.nn.traverse$loading__6254__auto____27808;
import cortex.nn.traverse$network__GT_forward_traversal_and_buffers;
import cortex.nn.traverse$record_first_seen_buffer_id_index;
import cortex.nn.traverse$remove_non_trainable;
import cortex.nn.traverse$reverse_forward_traversal;
import cortex.nn.traverse$stream_arguments__GT_buffers;
import cortex.nn.traverse$trainable_loss_term_argument_QMARK_;
import cortex.nn.traverse$training_traversal;
import cortex.nn.traverse$traversal__GT_buffers;
import cortex.nn.traverse$traversal_buffers;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class traverse__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__3;
    public static final AFn const__4;
    public static final Var const__5;
    public static final AFn const__14;
    public static final Var const__15;
    public static final AFn const__18;
    public static final Var const__19;
    public static final AFn const__22;
    public static final Var const__23;
    public static final AFn const__26;
    public static final Var const__27;
    public static final AFn const__30;
    public static final Var const__31;
    public static final AFn const__34;
    public static final Var const__35;
    public static final AFn const__38;
    public static final Var const__39;
    public static final AFn const__42;
    public static final Var const__43;
    public static final AFn const__46;
    public static final Var const__47;
    public static final AFn const__50;
    public static final Var const__51;
    public static final AFn const__54;
    public static final Var const__55;
    public static final AFn const__58;
    public static final Var const__59;
    public static final AFn const__62;
    public static final Var const__63;
    public static final AFn const__66;
    public static final Var const__67;
    public static final AFn const__70;
    public static final Var const__71;
    public static final AFn const__74;
    public static final Var const__75;
    public static final AFn const__78;
    public static final Var const__79;
    public static final AFn const__82;
    public static final Var const__83;
    public static final AFn const__86;
    public static final Var const__87;
    public static final AFn const__90;
    public static final Var const__91;
    public static final AFn const__94;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__3);
        Object object2 = ((IFn)new traverse$loading__6254__auto____27808()).invoke();
        if (((Symbol)const__1).equals((Object)const__4)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new traverse$fn__39772())));
            v3 = null;
        }
        Var var = const__5;
        var.setMeta((IPersistentMap)const__14);
        Var var2 = var;
        var.bindRoot((Object)new traverse$ensure_unique_buffer_id());
        Var var3 = const__15;
        var3.setMeta((IPersistentMap)const__18);
        Var var4 = var3;
        var3.bindRoot((Object)new traverse$forward_traversal());
        Var var5 = const__19;
        var5.setMeta((IPersistentMap)const__22);
        Var var6 = var5;
        var5.bindRoot((Object)new traverse$graph_node__GT_pass_type());
        Var var7 = const__23;
        var7.setMeta((IPersistentMap)const__26);
        Var var8 = var7;
        var7.bindRoot((Object)new traverse$filter_traversal());
        Var var9 = const__27;
        var9.setMeta((IPersistentMap)const__30);
        Var var10 = var9;
        var9.bindRoot((Object)new traverse$buffer_desc__GT_map_key());
        Var var11 = const__31;
        var11.setMeta((IPersistentMap)const__34);
        Var var12 = var11;
        var11.bindRoot((Object)new traverse$traversal__GT_buffers());
        Var var13 = const__35;
        var13.setMeta((IPersistentMap)const__38);
        Var var14 = var13;
        var13.bindRoot((Object)new traverse$stream_arguments__GT_buffers());
        Var var15 = const__39;
        var15.setMeta((IPersistentMap)const__42);
        Var var16 = var15;
        var15.bindRoot((Object)new traverse$reverse_forward_traversal());
        Var var17 = const__43;
        var17.setMeta((IPersistentMap)const__46);
        Var var18 = var17;
        var17.bindRoot((Object)new traverse$remove_non_trainable());
        Var var19 = const__47;
        var19.setMeta((IPersistentMap)const__50);
        Var var20 = var19;
        var19.bindRoot((Object)new traverse$clean_traversal());
        Var var21 = const__51;
        var21.setMeta((IPersistentMap)const__54);
        Var var22 = var21;
        var21.bindRoot((Object)new traverse$network__GT_forward_traversal_and_buffers());
        Var var23 = const__55;
        var23.setMeta((IPersistentMap)const__58);
        Var var24 = var23;
        var23.bindRoot((Object)new traverse$training_traversal());
        Var var25 = const__59;
        var25.setMeta((IPersistentMap)const__62);
        Var var26 = var25;
        var25.bindRoot((Object)new traverse$trainable_loss_term_argument_QMARK_());
        Var var27 = const__63;
        var27.setMeta((IPersistentMap)const__66);
        Var var28 = var27;
        var27.bindRoot((Object)new traverse$gradient_loss_function());
        Var var29 = const__67;
        var29.setMeta((IPersistentMap)const__70);
        Var var30 = var29;
        var29.bindRoot((Object)new traverse$inference_traversal());
        Var var31 = const__71;
        var31.setMeta((IPersistentMap)const__74);
        Var var32 = var31;
        var31.bindRoot((Object)new traverse$traversal_buffers());
        Var var33 = const__75;
        var33.setMeta((IPersistentMap)const__78);
        Var var34 = var33;
        var33.bindRoot((Object)new traverse$get_forward_buffers());
        Var var35 = const__79;
        var35.setMeta((IPersistentMap)const__82);
        Var var36 = var35;
        var35.bindRoot((Object)new traverse$get_backward_buffers());
        Var var37 = const__83;
        var37.setMeta((IPersistentMap)const__86);
        Var var38 = var37;
        var37.bindRoot((Object)new traverse$record_first_seen_buffer_id_index());
        Var var39 = const__87;
        var39.setMeta((IPersistentMap)const__90);
        Var var40 = var39;
        var39.bindRoot((Object)new traverse$buffer_seq());
        Var var41 = const__91;
        var41.setMeta((IPersistentMap)const__94);
        Var var42 = var41;
        var41.bindRoot((Object)new traverse$generate_traversal_buffer_pools());
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"cortex.nn.traverse")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Various graph traversal algorithms needed in order to implement\n  either inference or gradient descent on a layer graph.\n\n  Note that input-bindings are maps from node-id to stream\n  while output bindings are maps from node-id to {:stream :loss}."}));
        const__3 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Various graph traversal algorithms needed in order to implement\n  either inference or gradient descent on a layer graph.\n\n  Note that input-bindings are maps from node-id to stream\n  while output bindings are maps from node-id to {:stream :loss}."});
        const__4 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__5 = RT.var((String)"cortex.nn.traverse", (String)"ensure-unique-buffer-id");
        const__14 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"id")), RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"buffer")}), (Object)Symbol.intern(null, (String)"buffer-ids")))), RT.keyword(null, (String)"line"), 19, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__15 = RT.var((String)"cortex.nn.traverse", (String)"forward-traversal");
        const__18 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network")))), RT.keyword(null, (String)"doc"), "A forward traversal is a linear dfs order sequence.\n  There is an optional argument to remove nodes of a particular type from\n  the traversal.\n\n  Each item in the sequence is a map of:\n  {:incoming buffer-map-seq\n  :id\n  :outgoing buffer-map-seq}\n  ", RT.keyword(null, (String)"line"), 27, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__19 = RT.var((String)"cortex.nn.traverse", (String)"graph-node->pass-type");
        const__22 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"graph-node"), (Object)Symbol.intern(null, (String)"pass-type")))), RT.keyword(null, (String)"line"), 121, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__23 = RT.var((String)"cortex.nn.traverse", (String)"filter-traversal");
        const__26 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"compute-graph")), RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"network")}), (Object)Symbol.intern(null, (String)"pass-type"), (Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"doc"), "Removes bits of the traversal that aren't needed (e.g. no dropout used in\n  inference), and then corrects the input/output ids accordingly.", RT.keyword(null, (String)"line"), 128, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__27 = RT.var((String)"cortex.nn.traverse", (String)"buffer-desc->map-key");
        const__30 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"buffer-desc")))), RT.keyword(null, (String)"line"), 175, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__31 = RT.var((String)"cortex.nn.traverse", (String)"traversal->buffers");
        const__34 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"doc"), "Traversals initial hold id of incoming nodes.  For the next steps we need the incoming and\n  outgoing edges to hold unique ids such that the incoming buffer of the next step points to the\n  outgoing buffer of the previous step.", RT.keyword(null, (String)"line"), 180, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__35 = RT.var((String)"cortex.nn.traverse", (String)"stream-arguments->buffers");
        const__38 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)Symbol.intern(null, (String)"buffer-map"), (Object)Symbol.intern(null, (String)"graph-type")))), RT.keyword(null, (String)"line"), 200, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__39 = RT.var((String)"cortex.nn.traverse", (String)"reverse-forward-traversal");
        const__42 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"forward-traversal")))), RT.keyword(null, (String)"doc"), "See create-forward-traversal.  Reverse of same sequence.", RT.keyword(null, (String)"line"), 210, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__43 = RT.var((String)"cortex.nn.traverse", (String)"remove-non-trainable");
        const__46 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"line"), 223, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__47 = RT.var((String)"cortex.nn.traverse", (String)"clean-traversal");
        const__50 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"trav")))), RT.keyword(null, (String)"doc"), "Remove extraneous information from the io buffer list of the nodes to keep the traversal\ndatastructure as precise as possible.  This will remove at least the dimension member which from\nthe client's perspective is located in the buffers section.", RT.keyword(null, (String)"line"), 237, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__51 = RT.var((String)"cortex.nn.traverse", (String)"network->forward-traversal-and-buffers");
        const__54 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)Symbol.intern(null, (String)"graph-type")))), RT.keyword(null, (String)"doc"), "Given a network return a tuple or the forward traversal and the buffer allocation", RT.keyword(null, (String)"line"), 251, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__55 = RT.var((String)"cortex.nn.traverse", (String)"training-traversal");
        const__58 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)Symbol.intern(null, (String)"&"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"keep-non-trainable?"))})))), RT.keyword(null, (String)"doc"), "Given a network create master buffer list, traversals (forward,backward)\n  and input and output buffer lists.\n\n  Each traversal is a sequence of maps like in create-forward-traversal\n  except the incoming and outgoing ids are buffer ids.  Input bindings\n  are pairs of node to stream name.  Output bindings for gradient descent\n  are also pairs of node-id to stream name or they can be\n  pairs of node-id to [stream-name loss-function].\n\n  You can specify a loss here directly or you can specify loss terms around the graph.\n  Any terms in the graph are coalesced and appended to the passed-in loss to build a\n  datastructure describing the final loss function.\n\n  Note that input-bindings are maps from stream to node-id\n  while output-bindings are maps from node-id to {:stream :loss}!\n\n  {:buffers <id->{:size}>\n   :forward <where incoming/outgoing maps to buffer id>\n   :backward <where incoming/outgoing maps to buffer id>}\n  ", RT.keyword(null, (String)"line"), 260, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__59 = RT.var((String)"cortex.nn.traverse", (String)"trainable-loss-term-argument?");
        const__62 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)Symbol.intern(null, (String)"nodes-in-traversal"), (Object)Symbol.intern(null, (String)"loss-term")))), RT.keyword(null, (String)"line"), 303, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__63 = RT.var((String)"cortex.nn.traverse", (String)"gradient-loss-function");
        const__66 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"backward")), RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"traversal")})))), RT.keyword(null, (String)"doc"), "Filter the general network loss function terms to remove terms that do not contribute\n  to training gradients.  Loss functions that do not produce any gradients\n  *used in training* are filtered out.  The determination of used in training means\n  that the node takes part of the backward pass and that some of the parameters that the loss term\n  can produce gradients for are actually trainable or that it produces node output gradients.", RT.keyword(null, (String)"line"), 325, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__67 = RT.var((String)"cortex.nn.traverse", (String)"inference-traversal");
        const__70 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"network")))), RT.keyword(null, (String)"doc"), "Similar to network->gradient-descent however in this case we have the option\n  of optimizing for memory which means we can aggressively reuse buffers *or*\n  optimising for speed in which case the result is the forward pass of gradient descent\n  and we expect implementations to have multiple batches in flight simultaneously.  We\n  default to optimising for memory because this avoids OOM situations with large networks.", RT.keyword(null, (String)"line"), 350, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__71 = RT.var((String)"cortex.nn.traverse", (String)"traversal-buffers");
        const__74 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"line"), 364, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__75 = RT.var((String)"cortex.nn.traverse", (String)"get-forward-buffers");
        const__78 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"doc"), "Get the set of buffers used for the forward pass", RT.keyword(null, (String)"line"), 372, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__79 = RT.var((String)"cortex.nn.traverse", (String)"get-backward-buffers");
        const__82 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"doc"), "Get the set of buffers used for the backward pass", RT.keyword(null, (String)"line"), 379, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__83 = RT.var((String)"cortex.nn.traverse", (String)"record-first-seen-buffer-id-index");
        const__86 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"buffer-list")))), RT.keyword(null, (String)"doc"), "Return a map of index to a list of buffers first seen at that index.", RT.keyword(null, (String)"line"), 386, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__87 = RT.var((String)"cortex.nn.traverse", (String)"buffer-seq");
        const__90 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"buffers"), (Object)Symbol.intern(null, (String)"allocation-event")))), RT.keyword(null, (String)"doc"), "Flatten out the buffers datastructure on the access patter to a flat list of\n{:allocation-event [alloc-or-dealloc usage] id-or-stream}.  This simplifies the reductions\nto actually build up the pools and track the allocation/deallocation of the buffers.", RT.keyword(null, (String)"line"), 406, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
        const__91 = RT.var((String)"cortex.nn.traverse", (String)"generate-traversal-buffer-pools");
        const__94 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"traversal")))), RT.keyword(null, (String)"doc"), "Generate a set of pools to use for the buffers.  The traversal system guarantees that it is safe to use the pool\nwith a reshape to the buffer shape in question.  So many buffers are assigned to a single pool and we guarantee\nthat those buffers can overwrite each other because the data in the buffer isn't useful at the time the other\nbuffer is overwritting this buffer.", RT.keyword(null, (String)"line"), 419, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "cortex/nn/traverse.clj"});
    }

    static {
        traverse__init.__init0();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"cortex.nn.traverse__init").getClassLoader());
        try {
            traverse__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

