// Targeted by JavaCPP version 1.2.4: DO NOT EDIT THIS FILE

package think.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class hdf5 extends think.hdf5.presets.hdf5 {
    static { Loader.load(); }

// Parsed from <hdf5.hpp>

// #ifndef HDF5HPP
// #define HDF5HPP

// #include <H5Cpp.h>
// #include <string>
// #include <vector>
// #include <map>
// #include <memory>

  @Namespace("think::hdf5") public static class Access extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Access() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Access(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Access(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Access position(long position) {
          return (Access)super.position(position);
      }
  
    /** enum think::hdf5::Access::EEnum */
    public static final int
      excl =  1 << 0,
      trunc =  1 << 1,
      rdonly =  1 << 2,
      rdrw =  1 << 3,
      debug =  1 << 4,
      create =  1 << 5;
  }

  @Namespace("think::hdf5") public static class EObjType extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public EObjType() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public EObjType(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public EObjType(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public EObjType position(long position) {
          return (EObjType)super.position(position);
      }
  
    /** enum think::hdf5::EObjType::EEnum */
    public static final int
      unknown = -1,
      group = 0,
      dataset = 1,
      datatype = 2,
      file = 3;
  }

  @Namespace("think::hdf5") public static class abstract_ds extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public abstract_ds(Pointer p) { super(p); }
  
    /** enum think::hdf5::abstract_ds::EDType */
    public static final int
      dt_no_class = -1,
      dt_integer = 0,
      dt_float = 1,
      dt_time = 2,
      dt_string = 3,
      dt_bitfield = 4,
      dt_opaque = 5,
      dt_compound = 6,
      dt_reference = 7,
      dt_enum = 8,
      dt_vlen = 9,
      dt_array = 10;
    public native @Cast("think::hdf5::abstract_ds::EDType") int get_type_class();
    public native @Cast("size_t") long get_in_mem_data_size();
  }

  @Namespace("think::hdf5") public static class attribute extends abstract_ds {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public attribute(Pointer p) { super(p); }
  
    public native @StdString BytePointer name();
    public native void read(Pointer buf, @Cast("size_t") long buf_size);
  }

  @Namespace("think::hdf5") public static class location extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public location() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public location(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public location(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public location position(long position) {
          return (location)super.position(position);
      }
  
    public native @Cast("size_t") long get_attribute_count();
    public native attribute get_attribute(@Cast("size_t") long idx);
  }

  @Namespace("think::hdf5") public static class object_registry extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public object_registry(Pointer p) { super(p); }
  
    public native object dereference( int obj_id, long file_offset );
  }

  @Namespace("think::hdf5") public static class object extends location {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public object(Pointer p) { super(p); }
  
    public native @Cast("think::hdf5::EObjType::EEnum") int type();
    public native @StdString BytePointer name();
    public native @Cast("size_t") long child_count();
    public native object get_child( @Cast("size_t") long idx );
    public native dataset to_dataset();
    public native @ByRef object_registry registry();
    public native int obj_id();
  }

  @Namespace("think::hdf5") public static class dataset extends object {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public dataset(Pointer p) { super(p); }
      public abstract_ds asabstract_ds() { return asabstract_ds(this); }
      @Namespace public static native @Name("static_cast<think::hdf5::abstract_ds*>") abstract_ds asabstract_ds(dataset pointer);
  
    /** enum think::hdf5::dataset::EEnum */
    public static final int
      ds_no_class = -1,
      ds_scalar = 0,
      ds_simple = 1,
      ds_null = 2;
    public native @Cast("bool") boolean is_simple();
    public native @Cast("size_t") long ndims();
    //dims are hsize_t so use the library function call to find the sizeof_hsize_t
    //dims are ndims * sizeof(hsize_t)
    public native void get_dims( Pointer dims );
    public native void read( Pointer buf, @Cast("size_t") long buf_size);
    public native @Cast("bool") boolean is_variable_len_string();
    public native @Cast("size_t") long string_column_size();
    public native @Cast("size_t") long string_size();
    //Buf is an array of pointers max(1, n-dims)
    public native void read_variable_string(Pointer buf, @Cast("size_t") long buf_size );
    public native void release_variable_string( Pointer buf );
    public native void read_string(Pointer buf);
  }



// #endif


// Parsed from <hdf5_export.hpp>

// #ifndef HDF5_EXPORT_HPP
// #define HDF5_EXPORT_HPP
// #include "hdf5.hpp"
// #include "hdf5_impl.hpp"
  @Namespace("think::hdf5") public static class library extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public library() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public library(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public library(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public library position(long position) {
          return (library)super.position(position);
      }
  

    public static native void initLibrary();
    public static native void termH5cpp();
    public static native void getLibVersion( @Cast("unsigned*") @ByRef IntPointer majnum, @Cast("unsigned*") @ByRef IntPointer minnum, @Cast("unsigned*") @ByRef IntPointer relnum );
    public static native void getLibVersion( @Cast("unsigned*") @ByRef IntBuffer majnum, @Cast("unsigned*") @ByRef IntBuffer minnum, @Cast("unsigned*") @ByRef IntBuffer relnum );
    public static native void getLibVersion( @Cast("unsigned*") @ByRef int[] majnum, @Cast("unsigned*") @ByRef int[] minnum, @Cast("unsigned*") @ByRef int[] relnum );

    public static native int sizeof_hsize_t();

    public static native @Const object open_file( @Cast("const char*") BytePointer name, int access );
    public static native @Const object open_file( String name, int access );

    public static native void close_file( object file );
  }


// #endif


}
