// Targeted by JavaCPP version 1.2.4: DO NOT EDIT THIS FILE

package think.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class api extends think.hdf5.presets.api {
    static { Loader.load(); }

// Parsed from <hdf5.hpp>

// #ifndef HDF5HPP
// #define HDF5HPP
// #include <cstdlib>
// #include <cinttypes>

  @Namespace("think") public static class hdf5 extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public hdf5() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public hdf5(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public hdf5(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public hdf5 position(long position) {
          return (hdf5)super.position(position);
      }
  


    public static class Access extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public Access() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Access(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Access(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public Access position(long position) {
            return (Access)super.position(position);
        }
    
      /** enum think::hdf5::Access::EEnum */
      public static final int
	excl =  1 << 0,
	trunc =  1 << 1,
	rdonly =  1 << 2,
	rdrw =  1 << 3,
	debug =  1 << 4,
	create =  1 << 5;
    }

    public static class ObjType extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ObjType() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ObjType(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ObjType(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ObjType position(long position) {
            return (ObjType)super.position(position);
        }
    
      /** enum think::hdf5::ObjType::EEnum */
      public static final int
	H5I_UNINIT		=  (-2), /*uninitialized type			    */
	H5I_BADID		=  (-1),	/*invalid Type				    */
	H5I_FILE            = 1,  	/*type ID for File objects      	    */
	H5I_GROUP = 2,	                /*type ID for Group objects     	    */
	H5I_DATATYPE = 3,	        /*type ID for Datatype objects		    */
	H5I_DATASPACE = 4,	        /*type ID for Dataspace objects		    */
	H5I_DATASET = 5,	        /*type ID for Dataset objects		    */
	H5I_ATTR = 6,		        /*type ID for Attribute objects		    */
	H5I_REFERENCE = 7,	        /*type ID for Reference objects		    */
	H5I_VFL = 8,			/*type ID for virtual file layer	    */
	H5I_GENPROP_CLS = 9,            /*type ID for generic property list classes */
	H5I_GENPROP_LST = 10,            /*type ID for generic property lists        */
	H5I_ERROR_CLASS = 11,            /*type ID for error classes		    */
	H5I_ERROR_MSG = 12,              /*type ID for error messages		    */
	H5I_ERROR_STACK = 13,            /*type ID for error stacks		    */
	H5I_NTYPES = 14;		        /*number of library types, MUST BE LAST!    */
    }

    public static class EDatasetType extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public EDatasetType() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public EDatasetType(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public EDatasetType(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public EDatasetType position(long position) {
            return (EDatasetType)super.position(position);
        }
    
      /** enum think::hdf5::EDatasetType::EEnum */
      public static final int
	dt_no_class = -1,
	dt_integer = 0,
	dt_float = 1,
	dt_time = 2,
	dt_string = 3,
	dt_bitfield = 4,
	dt_opaque = 5,
	dt_compound = 6,
	dt_reference = 7,
	dt_enum = 8,
	dt_vlen = 9,
	dt_array = 10;
    }

    public static class FileObjType extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public FileObjType() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public FileObjType(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FileObjType(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public FileObjType position(long position) {
            return (FileObjType)super.position(position);
        }
    
      /** enum think::hdf5::FileObjType::EEnum */
      public static final int
	OBJ_FILE	 =  0x0001,
	OBJ_DATASET	 =  0x0002,
	OBJ_GROUP	 =  0x0004,
	OBJ_DATATYPE     =  0x0008,
	OBJ_ATTR         =  0x0010,
	OBJ_ALL 	 =  OBJ_FILE|OBJ_DATASET|OBJ_GROUP|OBJ_DATATYPE|OBJ_ATTR;
    }

    public static class GroupStorageType extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public GroupStorageType() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public GroupStorageType(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public GroupStorageType(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public GroupStorageType position(long position) {
            return (GroupStorageType)super.position(position);
        }
    
      /** enum think::hdf5::GroupStorageType::EEnum */
      public static final int
	H5G_STORAGE_TYPE_UNKNOWN = -1,	/* Unknown link storage type	*/
	H5G_STORAGE_TYPE_SYMBOL_TABLE = 0,      /* Links in group are stored with a "symbol table" */
	/* (this is sometimes called "old-style" groups) */
	H5G_STORAGE_TYPE_COMPACT = 1,		/* Links are stored in object header */
	H5G_STORAGE_TYPE_DENSE = 2; 		/* Links are stored in fractal heap & indexed with v2 B-tree */
    }

    public static class H5GInfo extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public H5GInfo() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public H5GInfo(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public H5GInfo(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public H5GInfo position(long position) {
            return (H5GInfo)super.position(position);
        }
    
      public native @Cast("think::hdf5::GroupStorageType::EEnum") int storage_type(); public native H5GInfo storage_type(int storage_type);	        /* Type of storage for links in group */
      public native @Cast("size_t") long nlinks(); public native H5GInfo nlinks(long nlinks);		        /* Number of links in group */
      public native long max_corder(); public native H5GInfo max_corder(long max_corder);             /* Current max. creation order value for group */
      public native int mounted(); public native H5GInfo mounted(int mounted);                /* Whether group has a file mounted on it */
    }

    public static class TypeClass extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public TypeClass() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public TypeClass(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public TypeClass(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public TypeClass position(long position) {
            return (TypeClass)super.position(position);
        }
    
      /** enum think::hdf5::TypeClass::EEnum */
      public static final int
	H5T_NO_CLASS         = -1,  /*error                                      */
	H5T_INTEGER          = 0,   /*integer types                              */
	H5T_FLOAT            = 1,   /*floating-point types                       */
	H5T_TIME             = 2,   /*date and time types                        */
	H5T_STRING           = 3,   /*character string types                     */
	H5T_BITFIELD         = 4,   /*bit field types                            */
	H5T_OPAQUE           = 5,   /*opaque types                               */
	H5T_COMPOUND         = 6,   /*compound types                             */
	H5T_REFERENCE        = 7,   /*reference types                            */
	H5T_ENUM		 = 8,	/*enumeration types                          */
	H5T_VLEN		 = 9,	/*Variable-Length types                      */
	H5T_ARRAY	         = 10,	/*Array types                                */

	H5T_NCLASSES = 11;                /*this must be last                          */
    }

    public static native @Cast("think::hdf5::herr_t") int H5open();
    public static native @Cast("think::hdf5::herr_t") int H5close();
    public static native @Cast("think::hdf5::herr_t") int H5get_libversion(@Cast("unsigned*") IntPointer majnum, @Cast("unsigned*") IntPointer minnum, @Cast("unsigned*") IntPointer relnum);
    public static native @Cast("think::hdf5::herr_t") int H5get_libversion(@Cast("unsigned*") IntBuffer majnum, @Cast("unsigned*") IntBuffer minnum, @Cast("unsigned*") IntBuffer relnum);
    public static native @Cast("think::hdf5::herr_t") int H5get_libversion(@Cast("unsigned*") int[] majnum, @Cast("unsigned*") int[] minnum, @Cast("unsigned*") int[] relnum);
    public static native @Cast("think::hdf5::htri_t") int H5Fis_hdf5(@Cast("const char*") BytePointer filename);
    public static native @Cast("think::hdf5::htri_t") int H5Fis_hdf5(String filename);
    public static native int to_hdf5_access( int access );
    public static native @Cast("think::hdf5::hid_t") long H5Fopen(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags );
    public static native @Cast("think::hdf5::hid_t") long H5Fopen(String filename, @Cast("unsigned") int flags );
    public static native @Cast("think::hdf5::ssize_t") long H5Fget_obj_count(@Cast("think::hdf5::hid_t") long file_id, @Cast("think::hdf5::FileObjType::EEnum") int types);
    public static native @Cast("think::hdf5::ssize_t") long H5Fget_obj_ids(@Cast("think::hdf5::hid_t") long file_id, @Cast("think::hdf5::FileObjType::EEnum") int types, @Cast("size_t") long max_objs, @Cast("think::hdf5::hid_t*") CLongPointer obj_id_list);

    public static native @Cast("think::hdf5::ObjType::EEnum") int get_object_type(@Cast("think::hdf5::hid_t") long id);
    //Get the absolute name of an object
    public static native @Cast("think::hdf5::ssize_t") long get_name(@Cast("think::hdf5::hid_t") long id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
    public static native @Cast("think::hdf5::ssize_t") long get_name(@Cast("think::hdf5::hid_t") long id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
    public static native @Cast("think::hdf5::ssize_t") long get_name(@Cast("think::hdf5::hid_t") long id, @Cast("char*") byte[] name, @Cast("size_t") long size);
    //Close anything; file, object, group, dataspace, etc.
    public static native @Cast("think::hdf5::herr_t") int close_object( @Cast("think::hdf5::hid_t") long obj );

    public static native @Cast("think::hdf5::ssize_t") long get_num_children(@Cast("think::hdf5::hid_t") long loc_id);
    //Get the relative name of a child with respect to this object
    public static native @Cast("think::hdf5::ssize_t") long get_child_name( @Cast("think::hdf5::hid_t") long loc_id, @Cast("think::hdf5::ssize_t") long idx, @Cast("char*") BytePointer name, @Cast("size_t") long size);
    public static native @Cast("think::hdf5::ssize_t") long get_child_name( @Cast("think::hdf5::hid_t") long loc_id, @Cast("think::hdf5::ssize_t") long idx, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
    public static native @Cast("think::hdf5::ssize_t") long get_child_name( @Cast("think::hdf5::hid_t") long loc_id, @Cast("think::hdf5::ssize_t") long idx, @Cast("char*") byte[] name, @Cast("size_t") long size);
    //Some abstraction here to avoid lots of spurious arguments.
    public static native @Cast("think::hdf5::hid_t") long open_child(@Cast("think::hdf5::hid_t") long loc_id, @Cast("think::hdf5::hsize_t") long idx);

    public static native @Cast("think::hdf5::ssize_t") long get_num_attrs(@Cast("think::hdf5::hid_t") long loc_id);
    public static native @Cast("think::hdf5::hid_t") long open_attribute(@Cast("think::hdf5::hid_t") long loc_id, @Cast("think::hdf5::hsize_t") long idx);

    public static native @Cast("think::hdf5::hid_t") long open_datatype(@Cast("think::hdf5::hid_t") long attr_or_dataset_id );
    public static native @Cast("think::hdf5::TypeClass::EEnum") int get_datatype_class(@Cast("think::hdf5::hid_t") long type_id);
    public static native @Cast("think::hdf5::herr_t") int open_native_datatype( @Cast("think::hdf5::hid_t") long type_id );
    public static native @Cast("think::hdf5::ssize_t") long get_datatype_size( @Cast("think::hdf5::hid_t") long type_id );
    public static native @Cast("think::hdf5::ssize_t") long is_variable_len_string( @Cast("think::hdf5::hid_t") long type_id );
    public static native @Cast("think::hdf5::ssize_t") long get_datatype_native_size( @Cast("think::hdf5::hid_t") long type_id );
    public static native @Cast("think::hdf5::hid_t") long create_str_type();
    public static native @Cast("think::hdf5::hid_t") long create_variable_str_type();
    public static native @Cast("think::hdf5::herr_t") int set_datatype_size( @Cast("think::hdf5::hid_t") long dtype, @Cast("size_t") long size );

    public static native @Cast("think::hdf5::hid_t") long open_dataspace(@Cast("think::hdf5::hid_t") long attr_or_dataset_id);
    public static native @Cast("think::hdf5::ssize_t") long get_dataspace_num_elements( @Cast("think::hdf5::hid_t") long ds_id );
    public static native int get_dataspace_ndims(@Cast("think::hdf5::hid_t") long dataspace_id );
    public static native int get_dataspace_dims(@Cast("think::hdf5::hid_t") long dataspace_id, @Cast("think::hdf5::hsize_t*") LongPointer dims, @Cast("think::hdf5::hsize_t*") LongPointer maxdims);
    public static native int get_dataspace_dims(@Cast("think::hdf5::hid_t") long dataspace_id, @Cast("think::hdf5::hsize_t*") LongBuffer dims, @Cast("think::hdf5::hsize_t*") LongBuffer maxdims);
    public static native int get_dataspace_dims(@Cast("think::hdf5::hid_t") long dataspace_id, @Cast("think::hdf5::hsize_t*") long[] dims, @Cast("think::hdf5::hsize_t*") long[] maxdims);

    public static native @Cast("think::hdf5::herr_t") int read_data(@Cast("think::hdf5::hid_t") long attr_or_dataset_id, @Cast("think::hdf5::hid_t") long datatype_id, Pointer buf);

    public static native @Cast("think::hdf5::hid_t") long dereference(@Cast("think::hdf5::hid_t") long src_obj, @Cast("think::hdf5::ssize_t") long file_offset);
  }



// #endif


// Parsed from <hdf5_export.hpp>

// #ifndef HDF5_EXPORT_HPP
// #define HDF5_EXPORT_HPP
// #include "hdf5.hpp"
// #include "hdf5_impl.hpp"
// #endif


}
