# think.semantic-ui

[![Clojars Project](https://img.shields.io/clojars/v/tvanhens/think.semantic-ui.svg)](https://clojars.org/tvanhens/think.semantic-ui)

## Overview

Think.semantic-ui is a library that wraps around [Semantic UI React](http://react.semantic-ui.com/introduction)
for syntantic ease of use in ClojureScript. It enables us to use Semantic UI React components with a hiccup-like syntax. 

## Setting up think.semantic-ui

1. Add `[thinktopic/think.semantic-ui "0.1.2"]` to your dependencies
2. Add `"/css/semantic.min.css"` into your handler
```
(defn head []
  [:head
   [:meta {:charset "utf-8"}]
   [:meta {:name "viewport"
           :content "width=device-width, initial-scale=1"}]
   (include-css "/css/semantic.min.css" "/css/site.css")])
```

## Using think.semantic-ui

#### Lets make a [primary button](http://react.semantic-ui.com/elements/button#button-example-emphasis) 
1. Require `[think.semantic-ui :as foo]` in your namespace
2. Then call your component `foo/button` and add any optional class in a map.
```
(defn page []
    [foo/button {:primary true} "Blue Button"])
```

## Updating think.semantic-ui to a newer version

Currently the component vars are not auto generated. There are a
couple steps to bump the SemanticUIReact project version. First, check
cljsjs to see if a new version is available [cljsjs](https://github.com/cljsjs/packages/tree/master/semantic-ui-react).

If a newer version is available:

  1. Bump `project.clj` dep version to latest `[cljsjs/semantic-ui-react
   "0.XX.Y-0"]`
  2. Run `(think.semantic-ui/print-component-defs)` in a `cljs` REPL to print a set
     of generated functions defs which map to the latest SemanticUI
     components
  3. Copy those into `think.semantic-ui` replacing the old versions
  3. Make sure that the CSS in `resources/public/css/semantic.min.css` is the most up to date Semantic UI CSS. 
  If it is not,replace that CSS file with the most up to date one. 
  4. Check that think.semantic-ui is working correctly by running `lein install` in the 
  think.semantic-ui directory and adding `[thinktopic/think.semantic-ui "0.1.2"]` to your dependencies in
  another project/webapp. You'll also need to include `"/css/semantic.min.css"` in your handler. 
  5. If all is good, deploy to Clojars with `lein deploy`

 (TODO: add testing and demo page?)

## License

Copyright © 2017 ThinkTopic

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
