(defproject thinktopic/think.semantic-ui "0.1.4"
  :description "Minimal semantic-ui-react wrapper by ThinkTopic."
  :url "http://github.com/thinktopic/think.semantic-ui"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.7.1"
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.229"]
                 [camel-snake-kebab "0.4.0"]
                 ;; Update this version when latest version is updated with cljsjs
                 [cljsjs/semantic-ui-react "0.67.1-0"]
                 [reagent "0.6.0" :scope "provided"]]
  :plugins [[lein-figwheel "0.5.8"]
            [lein-cljsbuild "1.1.4" :exclusions [[org.clojure/clojure]]]]

  :source-paths ["src"]
  :resource-paths ["resources"]
  :clean-targets ^{:protect false} ["dev-resources/public/js/compiled" "target"]
  :cljsbuild {:builds
              [{:id "dev"
                :source-paths ["src"]
                :figwheel {:open-urls ["http://localhost:3449/index.html"]}
                :compiler {:main think.semantic-ui
                           :asset-path "js/compiled/out"
                           :output-to "dev-resources/public/js/compiled/think/semantic_ui.js"
                           :output-dir "dev-resources/public/js/compiled/out"
                           :source-map-timestamp true
                           :preloads [devtools.preload]}}
               {:id "min"
                :source-paths ["src"]
                :compiler {:output-to "dev-resources/public/js/compiled/think/semantic_ui.js"
                           :main think.semantic-ui.core
                           :optimizations :advanced
                           :pretty-print false}}]}
  :figwheel {:css-dirs ["dev-resources/public/css"]}
  :profiles {:dev {:dependencies [[binaryage/devtools "0.8.2"]
                                  [figwheel-sidecar "0.5.8"]
                                  [com.cemerick/piggieback "0.2.1"]
                                  [cljsjs/react-dom "15.4.0-0"]
                                  [cljsjs/react-dom-server "15.4.0-0"]]
                   :source-paths ["src" "dev"]
                   :resource-paths ["dev-resources"]
                   :repl-options {:init (set! *print-length* 50)
                                  :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
