# think.semantic-ui

[![Clojars Project](https://img.shields.io/clojars/v/thinktopic/think.semantic-ui.svg)](https://clojars.org/thinktopic/think.semantic-ui)

## Overview

Think.semantic-ui is a library that wraps [Semantic UI React](http://react.semantic-ui.com/introduction) and makes it easy to use in ClojureScript. With it, we can use Semantic UI React components with a hiccup-like syntax.

## Setting up think.semantic-ui

1. Add `[thinktopic/think.semantic-ui "0.A.XX.Y-0"]` to your dependencies
2. Add `"https://cdnjs.cloudflare.com/ajax/libs/semantic-ui/2.2.13/semantic.min.css"` into your handler
```clj
(defn head []
  [:head
    [:meta {:charset "utf-8"}]
    [:meta {:name "viewport"
           :content "width=device-width, initial-scale=1"}]
   (include-css "https://cdnjs.cloudflare.com/ajax/libs/semantic-ui/2.2.13/semantic.min.css" "/css/site.css")])
```

## Using think.semantic-ui

#### Lets make a [primary button](http://react.semantic-ui.com/elements/button#button-example-emphasis)
1. Require `[think.semantic-ui :as ui]` in your namespace
2. Then call your component `ui/button` and add any optional class in a map.
```clj
(defn page []
  [ui/button {:primary true} "Blue Button"])
```

## Updating think.semantic-ui to a newer version

Currently the component vars are not auto generated. There are a couple steps to bump the SemanticUIReact project version. First, check cljsjs to see if a new version is available [cljsjs](https://github.com/cljsjs/packages/tree/master/semantic-ui-react).

If a newer version is available:

  1. Bump `project.clj` dep version to latest `[cljsjs/semantic-ui-react "0.XX.Y-0"]`
  1. Run `(think.semantic-ui/print-component-defs)` in a `cljs` REPL to print a set of generated functions defs which map to the latest SemanticUI components
  1. Copy those into `think.semantic-ui` replacing the old versions
  1. Make sure that the CSS in `resources/public/css/semantic.min.css` is the most up to date Semantic UI CSS. If it is not, replace that CSS file with the most up to date one.
  1. Check that think.semantic-ui is working correctly by running `lein install` in the think.semantic-ui directory and adding `[thinktopic/think.semantic-ui "0.A.XX.Y-0"]` to your dependencies in another project/webapp. You'll also need to include `"/css/semantic.min.css"` in your handler.
  1. If all is good, deploy to Clojars with `lein deploy clojars`

 (TODO: add testing and demo page? -- create a folder here called `examples` with an app in it that requires and uses this library.)

## License

Copyright © 2017 ThinkTopic

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
