<a name="top"/>
# *ExploitTarget* Map

[ExploitTargetType](http://stixproject.github.io/data-model/1.2/et/ExploitTargetType/)


## MapEntry :id ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :id

* String Value
  * IDs are strings of the form: type-<128bitUUID>, for example `judgment-de305d54-75b4-431b-adb2-eb6b9e546014` for a [Judgement](judgement.md). This _ID_ type compares to the STIX _id_ field.  The optional STIX _idref_ field is not used.
  * Plumatic Schema: Str

## MapEntry :type ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :type

* String Value
  * Plumatic Schema: Str

## MapEntry :schema_version ∷ String

CTIM schema version for this entity

* This entry is required

* Keyword Key
  * Plumatic Schema: :schema_version

* String Value
  * Plumatic Schema: (enum ...)
  * Must equal: "0.2.0"

## MapEntry :uri ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :uri

* String Value
  * A URI
  * Plumatic Schema: Str

## MapEntry :revision ∷ Integer

* This entry is optional

* Keyword Key
  * Plumatic Schema: :revision

* Integer Value
  * Plumatic Schema: Int

## MapEntry :external_ids ∷ [String]

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :external_ids

* String Value
  * Plumatic Schema: [Str]

## MapEntry :timestamp ∷ Inst (Date)

* This entry is optional

* Keyword Key
  * Plumatic Schema: :timestamp

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

## MapEntry :language ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :language

* String Value
  * Plumatic Schema: Str

## MapEntry :tlp ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :tlp

* String Value
  * TLP Stand for [Traffic Light Protocol](https://www.us-cert.gov/tlp). It indicates precisely how this resource is intended to be shared, replicated, copied...
  * Plumatic Schema: (enum ...)
  * Default: green
  * Allowed Values:
    * amber
    * green
    * red
    * white

## MapEntry :source ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

## MapEntry :source_uri ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source_uri

* String Value
  * A URI
  * Plumatic Schema: Str

## MapEntry :title ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :title

* String Value
  * Plumatic Schema: Str

## MapEntry :description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Markdown text
  * Plumatic Schema: Str

## MapEntry :short_description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

## MapEntry :type ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :type

* String Value
  * Plumatic Schema: (enum ...)
  * Must equal: "exploit-target"

## MapEntry :valid_time ∷ *ValidTime* Map

* This entry is required

* Keyword Key
  * Plumatic Schema: :valid_time

<a name="map1-ref"/>
* *ValidTime* Map Value
  * Details: [*ValidTime* Map](#map1)

## MapEntry :vulnerability ∷ [*Vulnerability* Map]

identifies and characterizes a Vulnerability as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :vulnerability

<a name="map2-ref"/>
* *Vulnerability* Map Value
  * Details: [*Vulnerability* Map](#map2)

## MapEntry :weakness ∷ [*Weakness* Map]

identifies and characterizes a Weakness as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :weakness

<a name="map3-ref"/>
* *Weakness* Map Value
  * Details: [*Weakness* Map](#map3)

## MapEntry :configuration ∷ [*Configuration* Map]

identifies and characterizes a Configuration as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :configuration

<a name="map4-ref"/>
* *Configuration* Map Value
  * Details: [*Configuration* Map](#map4)

## MapEntry :potential_COAs ∷ [*RelatedCOA* Map]

identifies and characterizes a Configuration as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :potential_COAs

<a name="map5-ref"/>
* *RelatedCOA* Map Value
  * Details: [*RelatedCOA* Map](#map5)

## MapEntry :related_exploit_targets ∷ [*RelatedExploitTarget* Map]

identifies and characterizes a Configuration as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :related_exploit_targets

<a name="map6-ref"/>
* *RelatedExploitTarget* Map Value
  * Details: [*RelatedExploitTarget* Map](#map6)

<a name="map1"/>
# *ValidTime* Map

[return](#map1-ref)

Period of time when a cyber observation is valid.

* Reference: [ValidTimeType](http://stixproject.github.io/data-model/1.2/indicator/ValidTimeType/)

## MapEntry :start_time ∷ Inst (Date)

If not present, the valid time position of the indicator does not have an upper bound

* This entry is optional

* Keyword Key
  * Plumatic Schema: :start_time

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

## MapEntry :end_time ∷ Inst (Date)

If not present, the valid time position of the indicator does not have an upper bound

* This entry is optional

* Keyword Key
  * Plumatic Schema: :end_time

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

<a name="map2"/>
# *Vulnerability* Map

[return](#map2-ref)

* Reference: [VulnerabilityType](http://stixproject.github.io/data-model/1.2/et/VulnerabilityType/)

## MapEntry :title ∷ String

title for this vulnerability

* This entry is required

* Keyword Key
  * Plumatic Schema: :title

* String Value
  * Plumatic Schema: Str

## MapEntry :description ∷ String

title for this vulnerability

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

## MapEntry :is_known ∷ Boolean

whether or not the vulnerability is known (i.e. not a 0-day) at the time of characterization.

* This entry is optional

* Keyword Key
  * Plumatic Schema: :is_known

* Boolean Value
  * Plumatic Schema: Bool

## MapEntry :is_public_acknowledged ∷ Boolean

whether or not the vulnerability is publicly acknowledged by the vendor

* This entry is optional

* Keyword Key
  * Plumatic Schema: :is_public_acknowledged

* Boolean Value
  * Plumatic Schema: Bool

## MapEntry :short_description ∷ String

short text description of this vulnerability

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

## MapEntry :cve_id ∷ String

CVE identifier

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cve_id

* String Value
  * Plumatic Schema: Str

## MapEntry :osvdb_id ∷ Integer

OSVDB identifier

* This entry is optional

* Keyword Key
  * Plumatic Schema: :osvdb_id

* Integer Value
  * Plumatic Schema: Int

## MapEntry :source ∷ String

the source of the CVE or OSVDB as a textual description or URL

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

## MapEntry :discovered_datetime ∷ Inst (Date)

date and time that this vulnerability was first discovered

* This entry is optional

* Keyword Key
  * Plumatic Schema: :discovered_datetime

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

## MapEntry :published_datetime ∷ Inst (Date)

date and time that this vulnerability was first published

* This entry is optional

* Keyword Key
  * Plumatic Schema: :published_datetime

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

## MapEntry :affected_software ∷ [String]

list of platforms and software that are affected by this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :affected_software

* String Value
  * Plumatic Schema: [Str]

## MapEntry :references ∷ [String]

list of external references describing this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :references

* String Value
  * A URI
  * Plumatic Schema: [Str]

<a name="map3"/>
# *Weakness* Map

[return](#map3-ref)

* Reference: [WeaknessType](http://stixproject.github.io/data-model/1.2/et/WeaknessType/)

## MapEntry :description ∷ String

text description of this Weakness

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

## MapEntry :cwe_id ∷ String

CWE identifier for a particular weakness

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cwe_id

* String Value
  * Plumatic Schema: Str

<a name="map4"/>
# *Configuration* Map

[return](#map4-ref)

* Reference: [ConfigurationType](http://stixproject.github.io/data-model/1.2/et/ConfigurationType/)

## MapEntry :description ∷ String

text description of this Configuration

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

## MapEntry :short_description ∷ String

short text description of this Configuration

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

## MapEntry :cce_id ∷ String

CCE identifier for a configuration item

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cce_id

* String Value
  * Plumatic Schema: Str

<a name="map5"/>
# *RelatedCOA* Map

[return](#map5-ref)


## MapEntry :confidence ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :confidence

* String Value
  * Plumatic Schema: (enum ...)
  * Allowed Values:
    * High
    * Low
    * Medium
    * None
    * Unknown
  * Reference: [HighMedLowVocab](http://stixproject.github.io/data-model/1.2/stixVocabs/HighMediumLowVocab-1.0/)

## MapEntry :source ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

## MapEntry :relationship ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :relationship

* String Value
  * Plumatic Schema: Str

## MapEntry :COA_id ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :COA_id

* String Value
  * A URI leading to a COA
  * Plumatic Schema: Str

<a name="map6"/>
# *RelatedExploitTarget* Map

[return](#map6-ref)


## MapEntry :confidence ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :confidence

* String Value
  * Plumatic Schema: (enum ...)
  * Allowed Values:
    * High
    * Low
    * Medium
    * None
    * Unknown
  * Reference: [HighMedLowVocab](http://stixproject.github.io/data-model/1.2/stixVocabs/HighMediumLowVocab-1.0/)

## MapEntry :source ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

## MapEntry :relationship ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :relationship

* String Value
  * Plumatic Schema: Str

## MapEntry :exploit_target_id ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :exploit_target_id

* String Value
  * A URI leading to an exploit target
  * Plumatic Schema: Str
