<a name="top"/>
# *Relationship* Map

Represents a relationship between two entities

| key | type | required? |
| --- | ---- | --------- |
|[:id](#mapentry-id-string)|String|&#10003;|
|[:type](#mapentry-type-string)|String|&#10003;|
|[:schema_version](#mapentry-schema_version-string)|String|&#10003;|
|[:uri](#mapentry-uri-string)|String||
|[:revision](#mapentry-revision-integer)|Integer||
|[:external_ids](#mapentry-external_ids-string)|String||
|[:timestamp](#mapentry-timestamp-instdate)|Inst (Date)||
|[:language](#mapentry-language-string)|String||
|[:tlp](#mapentry-tlp-string)|String||
|[:title](#mapentry-title-string)|String||
|[:description](#mapentry-description-string)|String||
|[:short_description](#mapentry-short_description-string)|String||
|[:source](#mapentry-source-string)|String||
|[:source_uri](#mapentry-source_uri-string)|String||
|[:type](#mapentry-type-string)|String|&#10003;|
|[:relationship_type](#mapentry-relationship_type-string)|String|&#10003;|
|[:source_ref](#mapentry-source_ref-string)|String|&#10003;|
|[:target_ref](#mapentry-target_ref-string)|String|&#10003;|

<a name="mapentry-id-string"/>
## MapEntry :id ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :id

* String Value
  * IDs are strings of the form: type-<128bitUUID>, for example `judgment-de305d54-75b4-431b-adb2-eb6b9e546014` for a [Judgement](judgement.md). This _ID_ type compares to the STIX _id_ field.  The optional STIX _idref_ field is not used.
  * Plumatic Schema: Str

<a name="mapentry-type-string"/>
## MapEntry :type ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :type

* String Value
  * Plumatic Schema: Str

<a name="mapentry-schema_version-string"/>
## MapEntry :schema_version ∷ String

CTIM schema version for this entity

* This entry is required

* Keyword Key
  * Plumatic Schema: :schema_version

* String Value
  * Plumatic Schema: (enum ...)
  * Must equal: "0.3.1"

<a name="mapentry-uri-string"/>
## MapEntry :uri ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :uri

* String Value
  * A URI
  * Plumatic Schema: Str

<a name="mapentry-revision-integer"/>
## MapEntry :revision ∷ Integer

* This entry is optional

* Keyword Key
  * Plumatic Schema: :revision

* Integer Value
  * Plumatic Schema: Int

<a name="mapentry-external_ids-string"/>
## MapEntry :external_ids ∷ [String]

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :external_ids

* String Value
  * Plumatic Schema: [Str]

<a name="mapentry-timestamp-instdate"/>
## MapEntry :timestamp ∷ Inst (Date)

* This entry is optional

* Keyword Key
  * Plumatic Schema: :timestamp

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object, serialized as a string the field should follow the rules of the ISO8601 standard.
  * Plumatic Schema: Inst

<a name="mapentry-language-string"/>
## MapEntry :language ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :language

* String Value
  * Plumatic Schema: Str

<a name="mapentry-tlp-string"/>
## MapEntry :tlp ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :tlp

* String Value
  * TLP Stand for [Traffic Light Protocol](https://www.us-cert.gov/tlp). It indicates precisely how this resource is intended to be shared, replicated, copied...
  * Plumatic Schema: (enum ...)
  * Default: green
  * Allowed Values:
    * amber
    * green
    * red
    * white

<a name="mapentry-title-string"/>
## MapEntry :title ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :title

* String Value
  * Plumatic Schema: Str

<a name="mapentry-description-string"/>
## MapEntry :description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Markdown text
  * Plumatic Schema: Str

<a name="mapentry-short_description-string"/>
## MapEntry :short_description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source-string"/>
## MapEntry :source ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source_uri-string"/>
## MapEntry :source_uri ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source_uri

* String Value
  * A URI
  * Plumatic Schema: Str

<a name="mapentry-type-string"/>
## MapEntry :type ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :type

* String Value
  * Plumatic Schema: (enum ...)
  * Must equal: "relationship"

<a name="mapentry-relationship_type-string"/>
## MapEntry :relationship_type ∷ String

* This entry is required
* Dev Notes: Relationship_type is currently open, so using s/Str until we can define optionally extensible fields; :relationship_type v/DomainObjectRelationship

* Keyword Key
  * Plumatic Schema: :relationship_type

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source_ref-string"/>
## MapEntry :source_ref ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :source_ref

* String Value
  * A URI leading to an entity
  * Plumatic Schema: Str

<a name="mapentry-target_ref-string"/>
## MapEntry :target_ref ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :target_ref

* String Value
  * A URI leading to an entity
  * Plumatic Schema: Str
