(ns ctim.schemas.malware
  (:require #?(:clj  [flanders.core :as f :refer [def-entity-type def-map-type def-eq]]
               :cljs [flanders.core :as f :refer-macros [def-entity-type def-map-type def-eq]])
            [ctim.schemas.common :as c]
            [ctim.schemas.vocabularies :as v]))

(def type-identifier "malware")

(def-eq MalwareTypeIdentifier type-identifier)

(def malware-desc
  (str "Malware is a type of TTP that is also known as malicious code and "
       "malicious software, and refers to a program that is inserted into "
       "a system, usually covertly, with the intent of compromising the "
       "confidentiality, integrity, or availability of the victim's data, "
       "applications, or operating system (OS) or of otherwise annoying or "
       "disrupting the victim. Malware such as viruses and worms are usually "
       "designed to perform these nefarious functions in such a way that users "
       "are unaware of them, at least initially."))

(def malware-desc-link
  "[Malware](https://docs.google.com/document/d/1IvkLxg_tCnICsatu2lyxKmWmh1gY2h8HUNssKIE-UIA/pub#h.s5l7katgbp09)")

(def-entity-type Malware
  {:description malware-desc
   :reference malware-desc-link}
  c/base-entity-entries
  (f/required-entries
   (f/entry :type MalwareTypeIdentifier)
   (f/entry :name c/ShortString
            :description "A name used to identify the Malware sample.")
   (f/entry :labels [v/MalwareLabel]
            :description "The type of malware being described."))
  (f/optional-entries
   (f/entry :description c/Markdown
            :description (str "A description that provides more details and "
                              "context about the Malware, potentially including "
                              "its purpose and its key characteristics."))
   (f/entry :kill_chain_phases [c/KillChainPhase]
            :description (str "The list of Kill Chain Phases for which this "
                              "Malware can be used."))
   (f/entry :x_mitre_aliases [c/ShortString]
            :description "ATT&CK Software.aliases")))

(def-entity-type NewMalware
  "For submitting a new Malware"
  (:entries Malware)
  c/base-new-entity-entries
  (f/optional-entries
   (f/entry :type MalwareTypeIdentifier)))

(def-entity-type StoredMalware
  "A Malware as stored in the data store"
  (:entries Malware)
  c/base-stored-entity-entries)

(def MalwareRef
  (c/ref-for-type type-identifier))
