<a id="top"></a>
# *ExploitTarget* Object

Vulnerabilities or weaknesses in software, systems, networks, or configurations

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[id](#propertyid-string)| String| |&#10003;|
|[schema_version](#propertyschema_version-string)| String|CTIM schema version for this entity|&#10003;|
|[type](#propertytype-exploittargettypeidentifierstring)|ExploitTargetTypeIdentifier String| |&#10003;|
|[valid_time](#propertyvalid_time-validtimeobject)|*ValidTime* Object| |&#10003;|
|[configuration](#propertyconfiguration-configurationobjectlist)|*Configuration* Object List|identifies and characterizes a Configuration as a potential Exploit Target||
|[description](#propertydescription-string)| String| ||
|[external_ids](#propertyexternal_ids-stringlist)| String List| ||
|[external_references](#propertyexternal_references-externalreferenceobjectlist)|*ExternalReference* Object List|Specifies a list of external references which refers to non-CTIM information. This property is used to provide one or more URLs, descriptions, or IDs to records in other systems.||
|[language](#propertylanguage-string)| String| ||
|[revision](#propertyrevision-integer)|Integer| ||
|[short_description](#propertyshort_description-string)| String| ||
|[source](#propertysource-string)| String| ||
|[source_uri](#propertysource_uri-string)| String| ||
|[timestamp](#propertytimestamp-instdate)|Inst (Date)| ||
|[title](#propertytitle-string)| String| ||
|[tlp](#propertytlp-tlpstring)|TLP String| ||
|[vulnerability](#propertyvulnerability-vulnerabilityobjectlist)|*Vulnerability* Object List|identifies and characterizes a Vulnerability as a potential Exploit Target||
|[weakness](#propertyweakness-weaknessobjectlist)|*Weakness* Object List|identifies and characterizes a Weakness as a potential Exploit Target||

* Reference: [ExploitTargetType](http://stixproject.github.io/data-model/1.2/et/ExploitTargetType/)

<a id="propertyconfiguration-configurationobjectlist"></a>
## Property configuration ∷ *Configuration* Object List

identifies and characterizes a Configuration as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)


<a id="map5-ref"></a>
* *Configuration* Object Value
  * Details: [*Configuration* Object](#map5)

<a id="propertydescription-string"></a>
## Property description ∷  String

* This entry is optional


  * Markdown string with at most 5000 characters

<a id="propertyexternal_ids-stringlist"></a>
## Property external_ids ∷  String List

* This entry is optional
* This entry's type is sequential (allows zero or more values)



<a id="propertyexternal_references-externalreferenceobjectlist"></a>
## Property external_references ∷ *ExternalReference* Object List

Specifies a list of external references which refers to non-CTIM information. This property is used to provide one or more URLs, descriptions, or IDs to records in other systems.

* This entry is optional
* This entry's type is sequential (allows zero or more values)


<a id="map1-ref"></a>
* *ExternalReference* Object Value
  * Details: [*ExternalReference* Object](#map1)

<a id="propertyid-string"></a>
## Property id ∷  String

* This entry is required


  * IDs are URIs, for example `https://www.domain.com/ctia/judgement/judgement-de305d54-75b4-431b-adb2-eb6b9e546014` for a [Judgement](judgement.md). This _ID_ type compares to the STIX _id_ field. The optional STIX _idref_ field is not used.

<a id="propertylanguage-string"></a>
## Property language ∷  String

* This entry is optional


  * String with at most 1024 characters

<a id="propertyrevision-integer"></a>
## Property revision ∷ Integer

* This entry is optional


  * Zero, or a positive integer

<a id="propertyschema_version-string"></a>
## Property schema_version ∷  String

CTIM schema version for this entity

* This entry is required


  * A semantic version matching the CTIM version against which this object should be valid.

<a id="propertyshort_description-string"></a>
## Property short_description ∷  String

* This entry is optional


  * String with at most 2048 characters

<a id="propertysource-string"></a>
## Property source ∷  String

* This entry is optional


  * String with at most 2048 characters

<a id="propertysource_uri-string"></a>
## Property source_uri ∷  String

* This entry is optional


  * A URI

<a id="propertytimestamp-instdate"></a>
## Property timestamp ∷ Inst (Date)

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertytitle-string"></a>
## Property title ∷  String

* This entry is optional


  * String with at most 1024 characters

<a id="propertytlp-tlpstring"></a>
## Property tlp ∷ TLP String

* This entry is optional


  * TLP stands for [Traffic Light Protocol](https://www.us-cert.gov/tlp), which indicates precisely how this resource is intended to be shared, replicated, copied, etc.
  * Default: green
  * Allowed Values:
    * amber
    * green
    * red
    * white

<a id="propertytype-exploittargettypeidentifierstring"></a>
## Property type ∷ ExploitTargetTypeIdentifier String

* This entry is required


  * Must equal: "exploit-target"

<a id="propertyvalid_time-validtimeobject"></a>
## Property valid_time ∷ *ValidTime* Object

* This entry is required


<a id="map2-ref"></a>
* *ValidTime* Object Value
  * Details: [*ValidTime* Object](#map2)

<a id="propertyvulnerability-vulnerabilityobjectlist"></a>
## Property vulnerability ∷ *Vulnerability* Object List

identifies and characterizes a Vulnerability as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)


<a id="map3-ref"></a>
* *Vulnerability* Object Value
  * Details: [*Vulnerability* Object](#map3)

<a id="propertyweakness-weaknessobjectlist"></a>
## Property weakness ∷ *Weakness* Object List

identifies and characterizes a Weakness as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)


<a id="map4-ref"></a>
* *Weakness* Object Value
  * Details: [*Weakness* Object](#map4)

<a id="map1"></a>
# *ExternalReference* Object

External references are used to describe pointers to information represented outside of CTIM. For example, a Malware object could use an external reference to indicate an ID for that malware in an external database or a report could use references to represent source material.

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[source_name](#propertysource_name-string)| String|The source within which the external-reference is defined (system, registry, organization, etc.)|&#10003;|
|[description](#propertydescription-string)| String| ||
|[external_id](#propertyexternal_id-string)| String|An identifier for the external reference content.||
|[hashes](#propertyhashes-stringlist)| String List|Specifies a dictionary of hashes for the contents of the url.||
|[url](#propertyurl-string)| String|A URL reference to an external resource||

* Reference: [External Reference](https://docs.google.com/document/d/1dIrh1Lp3KAjEMm8o2VzAmuV0Peu-jt9aAh1IHrjAroM/pub#h.72bcfr3t79jx)

<a id="propertydescription-string"></a>
## Property description ∷  String

* This entry is optional


  * Markdown string with at most 5000 characters

<a id="propertyexternal_id-string"></a>
## Property external_id ∷  String

An identifier for the external reference content.

* This entry is optional



<a id="propertyhashes-stringlist"></a>
## Property hashes ∷  String List

Specifies a dictionary of hashes for the contents of the url.

* This entry is optional
* This entry's type is sequential (allows zero or more values)



<a id="propertysource_name-string"></a>
## Property source_name ∷  String

The source within which the external-reference is defined (system, registry, organization, etc.)

* This entry is required


  * String with at most 2048 characters

<a id="propertyurl-string"></a>
## Property url ∷  String

A URL reference to an external resource

* This entry is optional


  * A URI

<a id="map2"></a>
# *ValidTime* Object

Period of time when a cyber observation is valid.

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[end_time](#propertyend_time-instdate)|Inst (Date)|If end_time is not present, then the valid time position of the object does not have an upper bound.||
|[start_time](#propertystart_time-instdate)|Inst (Date)|If not present, the valid time position of the indicator does not have an upper bound||

* Reference: [ValidTimeType](http://stixproject.github.io/data-model/1.2/indicator/ValidTimeType/)

<a id="propertyend_time-instdate"></a>
## Property end_time ∷ Inst (Date)

If end_time is not present, then the valid time position of the object does not have an upper bound.

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertystart_time-instdate"></a>
## Property start_time ∷ Inst (Date)

If not present, the valid time position of the indicator does not have an upper bound

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="map3"></a>
# *Vulnerability* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[description](#propertydescription-string)| String|Description of the Vulnerability|&#10003;|
|[title](#propertytitle-string)| String|title for this vulnerability|&#10003;|
|[affected_software](#propertyaffected_software-stringlist)| String List|list of platforms and software that are affected by this vulnerability||
|[cve_id](#propertycve_id-string)| String|CVE identifier||
|[discovered_datetime](#propertydiscovered_datetime-instdate)|Inst (Date)|date and time that this vulnerability was first discovered||
|[is_known](#propertyis_known-boolean)|Boolean|whether or not the vulnerability is known (i.e. not a 0-day) at the time of characterization.||
|[is_public_acknowledged](#propertyis_public_acknowledged-boolean)|Boolean|whether or not the vulnerability is publicly acknowledged by the vendor||
|[osvdb_id](#propertyosvdb_id-integer)|Integer|OSVDB identifier||
|[published_datetime](#propertypublished_datetime-instdate)|Inst (Date)|date and time that this vulnerability was first published||
|[references](#propertyreferences-stringlist)| String List|list of external references describing this vulnerability||
|[short_description](#propertyshort_description-string)| String|short text description of this vulnerability||
|[source](#propertysource-string)| String|the source of the CVE or OSVDB as a textual description or URL||

* Reference: [VulnerabilityType](http://stixproject.github.io/data-model/1.2/et/VulnerabilityType/)

<a id="propertyaffected_software-stringlist"></a>
## Property affected_software ∷  String List

list of platforms and software that are affected by this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)


  * String with at most 1024 characters

<a id="propertycve_id-string"></a>
## Property cve_id ∷  String

CVE identifier

* This entry is optional


  * String with at most 1024 characters

<a id="propertydescription-string"></a>
## Property description ∷  String

Description of the Vulnerability

* This entry is required


  * String with at most 5000 characters

<a id="propertydiscovered_datetime-instdate"></a>
## Property discovered_datetime ∷ Inst (Date)

date and time that this vulnerability was first discovered

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertyis_known-boolean"></a>
## Property is_known ∷ Boolean

whether or not the vulnerability is known (i.e. not a 0-day) at the time of characterization.

* This entry is optional



<a id="propertyis_public_acknowledged-boolean"></a>
## Property is_public_acknowledged ∷ Boolean

whether or not the vulnerability is publicly acknowledged by the vendor

* This entry is optional



<a id="propertyosvdb_id-integer"></a>
## Property osvdb_id ∷ Integer

OSVDB identifier

* This entry is optional



<a id="propertypublished_datetime-instdate"></a>
## Property published_datetime ∷ Inst (Date)

date and time that this vulnerability was first published

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertyreferences-stringlist"></a>
## Property references ∷  String List

list of external references describing this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)


  * A URI

<a id="propertyshort_description-string"></a>
## Property short_description ∷  String

short text description of this vulnerability

* This entry is optional


  * String with at most 2048 characters

<a id="propertysource-string"></a>
## Property source ∷  String

the source of the CVE or OSVDB as a textual description or URL

* This entry is optional


  * String with at most 1024 characters

<a id="propertytitle-string"></a>
## Property title ∷  String

title for this vulnerability

* This entry is required


  * String with at most 1024 characters

<a id="map4"></a>
# *Weakness* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[description](#propertydescription-string)| String|text description of this Weakness|&#10003;|
|[cwe_id](#propertycwe_id-string)| String|CWE identifier for a particular weakness||

* Reference: [WeaknessType](http://stixproject.github.io/data-model/1.2/et/WeaknessType/)

<a id="propertycwe_id-string"></a>
## Property cwe_id ∷  String

CWE identifier for a particular weakness

* This entry is optional


  * String with at most 1024 characters

<a id="propertydescription-string"></a>
## Property description ∷  String

text description of this Weakness

* This entry is required


  * String with at most 5000 characters

<a id="map5"></a>
# *Configuration* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[description](#propertydescription-string)| String|text description of this Configuration|&#10003;|
|[cce_id](#propertycce_id-string)| String|CCE identifier for a configuration item||
|[short_description](#propertyshort_description-string)| String|short text description of this Configuration||

* Reference: [ConfigurationType](http://stixproject.github.io/data-model/1.2/et/ConfigurationType/)

<a id="propertycce_id-string"></a>
## Property cce_id ∷  String

CCE identifier for a configuration item

* This entry is optional


  * String with at most 1024 characters

<a id="propertydescription-string"></a>
## Property description ∷  String

text description of this Configuration

* This entry is required


  * String with at most 5000 characters

<a id="propertyshort_description-string"></a>
## Property short_description ∷  String

short text description of this Configuration

* This entry is optional


  * String with at most 2048 characters
