<a name="top"/>
# *StoredExploitTarget* Map

An exploit-target as stored in the data store

| key | type | required? |
| --- | ---- | --------- |
|[:configuration](#mapentry-configuration-configurationmap)|*Configuration* Map||
|[:created](#mapentry-created-instdate)|Inst (Date)|&#10003;|
|[:description](#mapentry-description-string)|String||
|[:external_ids](#mapentry-external_ids-string)|String||
|[:id](#mapentry-id-string)|String|&#10003;|
|[:language](#mapentry-language-string)|String||
|[:modified](#mapentry-modified-instdate)|Inst (Date)||
|[:owner](#mapentry-owner-string)|String|&#10003;|
|[:revision](#mapentry-revision-integer)|Integer||
|[:schema_version](#mapentry-schema_version-string)|String|&#10003;|
|[:short_description](#mapentry-short_description-string)|String||
|[:source](#mapentry-source-string)|String||
|[:source_uri](#mapentry-source_uri-string)|String||
|[:timestamp](#mapentry-timestamp-instdate)|Inst (Date)||
|[:title](#mapentry-title-string)|String||
|[:tlp](#mapentry-tlp-string)|String||
|[:type](#mapentry-type-string)|String|&#10003;|
|[:valid_time](#mapentry-valid_time-validtimemap)|*ValidTime* Map|&#10003;|
|[:vulnerability](#mapentry-vulnerability-vulnerabilitymap)|*Vulnerability* Map||
|[:weakness](#mapentry-weakness-weaknessmap)|*Weakness* Map||

<a name="mapentry-configuration-configurationmap"/>
## MapEntry :configuration ∷ [*Configuration* Map]

identifies and characterizes a Configuration as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :configuration

<a name="map4-ref"/>
* *Configuration* Map Value
  * Details: [*Configuration* Map](#map4)

<a name="mapentry-created-instdate"/>
## MapEntry :created ∷ Inst (Date)

* This entry is required

* Keyword Key
  * Plumatic Schema: :created

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-description-string"/>
## MapEntry :description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Markdown text
  * Plumatic Schema: Str

<a name="mapentry-external_ids-string"/>
## MapEntry :external_ids ∷ [String]

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :external_ids

* String Value
  * Plumatic Schema: [Str]

<a name="mapentry-id-string"/>
## MapEntry :id ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :id

* String Value
  * IDs are strings of the form: type-<128bitUUID>, for example `judgment-de305d54-75b4-431b-adb2-eb6b9e546014` for a [Judgement](judgement.md). This _ID_ type compares to the STIX _id_ field.  The optional STIX _idref_ field is not used.
  * Plumatic Schema: Str

<a name="mapentry-language-string"/>
## MapEntry :language ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :language

* String Value
  * Plumatic Schema: Str

<a name="mapentry-modified-instdate"/>
## MapEntry :modified ∷ Inst (Date)

* This entry is optional

* Keyword Key
  * Plumatic Schema: :modified

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-owner-string"/>
## MapEntry :owner ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :owner

* String Value
  * Plumatic Schema: Str

<a name="mapentry-revision-integer"/>
## MapEntry :revision ∷ Integer

* This entry is optional

* Keyword Key
  * Plumatic Schema: :revision

* Integer Value
  * Plumatic Schema: Int

<a name="mapentry-schema_version-string"/>
## MapEntry :schema_version ∷ String

CTIM schema version for this entity

* This entry is required

* Keyword Key
  * Plumatic Schema: :schema_version

* String Value
  * A semantic version matching the CTIM version against which this object should be valid.
  * Plumatic Schema: Str

<a name="mapentry-short_description-string"/>
## MapEntry :short_description ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source-string"/>
## MapEntry :source ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source_uri-string"/>
## MapEntry :source_uri ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source_uri

* String Value
  * A URI
  * Plumatic Schema: Str

<a name="mapentry-timestamp-instdate"/>
## MapEntry :timestamp ∷ Inst (Date)

* This entry is optional

* Keyword Key
  * Plumatic Schema: :timestamp

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-title-string"/>
## MapEntry :title ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :title

* String Value
  * Plumatic Schema: Str

<a name="mapentry-tlp-string"/>
## MapEntry :tlp ∷ String

* This entry is optional

* Keyword Key
  * Plumatic Schema: :tlp

* String Value
  * TLP stands for [Traffic Light Protocol](https://www.us-cert.gov/tlp), which indicates precisely how this resource is intended to be shared, replicated, copied, etc.
  * Plumatic Schema: (enum ...)
  * Default: green
  * Allowed Values:
    * amber
    * green
    * red
    * white

<a name="mapentry-type-string"/>
## MapEntry :type ∷ String

* This entry is required

* Keyword Key
  * Plumatic Schema: :type

* String Value
  * Plumatic Schema: (enum ...)
  * Must equal: "exploit-target"

<a name="mapentry-valid_time-validtimemap"/>
## MapEntry :valid_time ∷ *ValidTime* Map

* This entry is required

* Keyword Key
  * Plumatic Schema: :valid_time

<a name="map1-ref"/>
* *ValidTime* Map Value
  * Details: [*ValidTime* Map](#map1)

<a name="mapentry-vulnerability-vulnerabilitymap"/>
## MapEntry :vulnerability ∷ [*Vulnerability* Map]

identifies and characterizes a Vulnerability as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :vulnerability

<a name="map2-ref"/>
* *Vulnerability* Map Value
  * Details: [*Vulnerability* Map](#map2)

<a name="mapentry-weakness-weaknessmap"/>
## MapEntry :weakness ∷ [*Weakness* Map]

identifies and characterizes a Weakness as a potential Exploit Target

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :weakness

<a name="map3-ref"/>
* *Weakness* Map Value
  * Details: [*Weakness* Map](#map3)

<a name="map1"/>
# *ValidTime* Map

Period of time when a cyber observation is valid.

| key | type | required? |
| --- | ---- | --------- |
|[:end_time](#mapentry-end_time-instdate)|Inst (Date)||
|[:start_time](#mapentry-start_time-instdate)|Inst (Date)||
* Reference: [ValidTimeType](http://stixproject.github.io/data-model/1.2/indicator/ValidTimeType/)

<a name="mapentry-end_time-instdate"/>
## MapEntry :end_time ∷ Inst (Date)

If end_time is not present, then the valid time position of the object does not have an upper bound.

* This entry is optional

* Keyword Key
  * Plumatic Schema: :end_time

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-start_time-instdate"/>
## MapEntry :start_time ∷ Inst (Date)

If not present, the valid time position of the indicator does not have an upper bound

* This entry is optional

* Keyword Key
  * Plumatic Schema: :start_time

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="map2"/>
# *Vulnerability* Map

| key | type | required? |
| --- | ---- | --------- |
|[:affected_software](#mapentry-affected_software-string)|String||
|[:cve_id](#mapentry-cve_id-string)|String||
|[:description](#mapentry-description-string)|String|&#10003;|
|[:discovered_datetime](#mapentry-discovered_datetime-instdate)|Inst (Date)||
|[:is_known](#mapentry-is_known-boolean)|Boolean||
|[:is_public_acknowledged](#mapentry-is_public_acknowledged-boolean)|Boolean||
|[:osvdb_id](#mapentry-osvdb_id-integer)|Integer||
|[:published_datetime](#mapentry-published_datetime-instdate)|Inst (Date)||
|[:references](#mapentry-references-string)|String||
|[:short_description](#mapentry-short_description-string)|String||
|[:source](#mapentry-source-string)|String||
|[:title](#mapentry-title-string)|String|&#10003;|
* Reference: [VulnerabilityType](http://stixproject.github.io/data-model/1.2/et/VulnerabilityType/)

<a name="mapentry-affected_software-string"/>
## MapEntry :affected_software ∷ [String]

list of platforms and software that are affected by this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :affected_software

* String Value
  * Plumatic Schema: [Str]

<a name="mapentry-cve_id-string"/>
## MapEntry :cve_id ∷ String

CVE identifier

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cve_id

* String Value
  * Plumatic Schema: Str

<a name="mapentry-description-string"/>
## MapEntry :description ∷ String

title for this vulnerability

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

<a name="mapentry-discovered_datetime-instdate"/>
## MapEntry :discovered_datetime ∷ Inst (Date)

date and time that this vulnerability was first discovered

* This entry is optional

* Keyword Key
  * Plumatic Schema: :discovered_datetime

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-is_known-boolean"/>
## MapEntry :is_known ∷ Boolean

whether or not the vulnerability is known (i.e. not a 0-day) at the time of characterization.

* This entry is optional

* Keyword Key
  * Plumatic Schema: :is_known

* Boolean Value
  * Plumatic Schema: Bool

<a name="mapentry-is_public_acknowledged-boolean"/>
## MapEntry :is_public_acknowledged ∷ Boolean

whether or not the vulnerability is publicly acknowledged by the vendor

* This entry is optional

* Keyword Key
  * Plumatic Schema: :is_public_acknowledged

* Boolean Value
  * Plumatic Schema: Bool

<a name="mapentry-osvdb_id-integer"/>
## MapEntry :osvdb_id ∷ Integer

OSVDB identifier

* This entry is optional

* Keyword Key
  * Plumatic Schema: :osvdb_id

* Integer Value
  * Plumatic Schema: Int

<a name="mapentry-published_datetime-instdate"/>
## MapEntry :published_datetime ∷ Inst (Date)

date and time that this vulnerability was first published

* This entry is optional

* Keyword Key
  * Plumatic Schema: :published_datetime

* Inst (Date) Value
  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.
  * Plumatic Schema: Inst

<a name="mapentry-references-string"/>
## MapEntry :references ∷ [String]

list of external references describing this vulnerability

* This entry is optional
* This entry's type is sequential (allows zero or more values)

* Keyword Key
  * Plumatic Schema: :references

* String Value
  * A URI
  * Plumatic Schema: [Str]

<a name="mapentry-short_description-string"/>
## MapEntry :short_description ∷ String

short text description of this vulnerability

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str

<a name="mapentry-source-string"/>
## MapEntry :source ∷ String

the source of the CVE or OSVDB as a textual description or URL

* This entry is optional

* Keyword Key
  * Plumatic Schema: :source

* String Value
  * Plumatic Schema: Str

<a name="mapentry-title-string"/>
## MapEntry :title ∷ String

title for this vulnerability

* This entry is required

* Keyword Key
  * Plumatic Schema: :title

* String Value
  * Plumatic Schema: Str

<a name="map3"/>
# *Weakness* Map

| key | type | required? |
| --- | ---- | --------- |
|[:cwe_id](#mapentry-cwe_id-string)|String||
|[:description](#mapentry-description-string)|String|&#10003;|
* Reference: [WeaknessType](http://stixproject.github.io/data-model/1.2/et/WeaknessType/)

<a name="mapentry-cwe_id-string"/>
## MapEntry :cwe_id ∷ String

CWE identifier for a particular weakness

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cwe_id

* String Value
  * Plumatic Schema: Str

<a name="mapentry-description-string"/>
## MapEntry :description ∷ String

text description of this Weakness

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

<a name="map4"/>
# *Configuration* Map

| key | type | required? |
| --- | ---- | --------- |
|[:cce_id](#mapentry-cce_id-string)|String||
|[:description](#mapentry-description-string)|String|&#10003;|
|[:short_description](#mapentry-short_description-string)|String||
* Reference: [ConfigurationType](http://stixproject.github.io/data-model/1.2/et/ConfigurationType/)

<a name="mapentry-cce_id-string"/>
## MapEntry :cce_id ∷ String

CCE identifier for a configuration item

* This entry is optional

* Keyword Key
  * Plumatic Schema: :cce_id

* String Value
  * Plumatic Schema: Str

<a name="mapentry-description-string"/>
## MapEntry :description ∷ String

text description of this Configuration

* This entry is required

* Keyword Key
  * Plumatic Schema: :description

* String Value
  * Plumatic Schema: Str

<a name="mapentry-short_description-string"/>
## MapEntry :short_description ∷ String

short text description of this Configuration

* This entry is optional

* Keyword Key
  * Plumatic Schema: :short_description

* String Value
  * Plumatic Schema: Str
