<a id="top"></a>
# *Vulnerability* Object

a mistake in software that can be directly used by a hacker to gain access to a system or network

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[description](#propertydescription-markdownstring)|Markdown String|A description that provides more details and context about the Vulnerability,potentially including its purpose and its key characteristics.|&#10003;|
|[id](#propertyid-string)| String|Globally unique URI identifying this object.|&#10003;|
|[schema_version](#propertyschema_version-string)| String|CTIM schema version for this entity|&#10003;|
|[type](#propertytype-vulnerabilitytypeidentifierstring)|VulnerabilityTypeIdentifier String|The fixed value vulnerability|&#10003;|
|[cve](#propertycve-cveobject)|*CVE* Object| ||
|[external_ids](#propertyexternal_ids-stringlist)| String List| ||
|[external_references](#propertyexternal_references-externalreferenceobjectlist)|*ExternalReference* Object List|Specifies a list of external references which refers to non-CTIM information. This property is used to provide one or more URLs, descriptions, or IDs to records in other systems.||
|[impact](#propertyimpact-vulnerabilityimpactobject)|*VulnerabilityImpact* Object| ||
|[language](#propertylanguage-shortstringstring)|ShortString String|The human language this object is specified in.||
|[last_modified_date](#propertylast_modified_date-instdate)|Inst (Date)| ||
|[published_date](#propertypublished_date-instdate)|Inst (Date)| ||
|[revision](#propertyrevision-integer)|Integer|A monotonically increasing revision, incremented each time the object is changed.||
|[short_description](#propertyshort_description-medstringstring)|MedString String|A single line, short summary of the object.||
|[source](#propertysource-medstringstring)|MedString String| ||
|[source_uri](#propertysource_uri-string)| String| ||
|[timestamp](#propertytimestamp-instdate)|Inst (Date)|The time this object was created at, or last modified.||
|[title](#propertytitle-shortstringstring)|ShortString String|A short title for this object, used as primary display and reference value||
|[tlp](#propertytlp-tlpstring)|TLP String|Specification for how, and to whom, this object can be shared.||

* Reference: [Vulnerability](http://docs.oasis-open.org/cti/stix/v2.0/cs01/part2-stix-objects/stix-v2.0-cs01-part2-stix-objects.html#_Toc496714334)

<a id="propertycve-cveobject"></a>
## Property cve ∷ *CVE* Object

* This entry is optional


<a id="map2-ref"></a>
* *CVE* Object Value
  * Details: [*CVE* Object](#map2)

<a id="propertydescription-markdownstring"></a>
## Property description ∷ Markdown String

A description that provides more details and context about the Vulnerability,potentially including its purpose and its key characteristics.

* This entry is required


  * Markdown string with at most 5000 characters

<a id="propertyexternal_ids-stringlist"></a>
## Property external_ids ∷  String List

* This entry is optional
* This entry's type is sequential (allows zero or more values)



<a id="propertyexternal_references-externalreferenceobjectlist"></a>
## Property external_references ∷ *ExternalReference* Object List

Specifies a list of external references which refers to non-CTIM information. This property is used to provide one or more URLs, descriptions, or IDs to records in other systems.

* This entry is optional
* This entry's type is sequential (allows zero or more values)


<a id="map1-ref"></a>
* *ExternalReference* Object Value
  * Details: [*ExternalReference* Object](#map1)

<a id="propertyid-string"></a>
## Property id ∷  String

Globally unique URI identifying this object.

* This entry is required


  * IDs are URIs, for example `https://www.domain.com/ctia/judgement/judgement-de305d54-75b4-431b-adb2-eb6b9e546014` for a [Judgement](judgement.md). This _ID_ type compares to the STIX _id_ field. The optional STIX _idref_ field is not used.

<a id="propertyimpact-vulnerabilityimpactobject"></a>
## Property impact ∷ *VulnerabilityImpact* Object

* This entry is optional


<a id="map3-ref"></a>
* *VulnerabilityImpact* Object Value
  * Details: [*VulnerabilityImpact* Object](#map3)

<a id="propertylanguage-shortstringstring"></a>
## Property language ∷ ShortString String

The human language this object is specified in.

* This entry is optional


  * String with at most 1024 characters

<a id="propertylast_modified_date-instdate"></a>
## Property last_modified_date ∷ Inst (Date)

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertypublished_date-instdate"></a>
## Property published_date ∷ Inst (Date)

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertyrevision-integer"></a>
## Property revision ∷ Integer

A monotonically increasing revision, incremented each time the object is changed.

* This entry is optional


  * Zero, or a positive integer

<a id="propertyschema_version-string"></a>
## Property schema_version ∷  String

CTIM schema version for this entity

* This entry is required


  * A semantic version matching the CTIM version against which this object should be valid.

<a id="propertyshort_description-medstringstring"></a>
## Property short_description ∷ MedString String

A single line, short summary of the object.

* This entry is optional


  * String with at most 2048 characters

<a id="propertysource-medstringstring"></a>
## Property source ∷ MedString String

* This entry is optional


  * String with at most 2048 characters

<a id="propertysource_uri-string"></a>
## Property source_uri ∷  String

* This entry is optional


  * A URI

<a id="propertytimestamp-instdate"></a>
## Property timestamp ∷ Inst (Date)

The time this object was created at, or last modified.

* This entry is optional


  * Schema definition for all date or timestamp values.  Time is stored internally as a java.util.Date object. Serialized as a string, the field should follow the rules of the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) standard.

<a id="propertytitle-shortstringstring"></a>
## Property title ∷ ShortString String

A short title for this object, used as primary display and reference value

* This entry is optional


  * String with at most 1024 characters

<a id="propertytlp-tlpstring"></a>
## Property tlp ∷ TLP String

Specification for how, and to whom, this object can be shared.

* This entry is optional


  * TLP stands for [Traffic Light Protocol](https://www.us-cert.gov/tlp), which indicates precisely how this resource is intended to be shared, replicated, copied, etc.
  * Default: green
  * Allowed Values:
    * amber
    * green
    * red
    * white

<a id="propertytype-vulnerabilitytypeidentifierstring"></a>
## Property type ∷ VulnerabilityTypeIdentifier String

The fixed value vulnerability

* This entry is required


  * The fixed value "vulnerability"
  * Must equal: "vulnerability"

<a id="map1"></a>
# *ExternalReference* Object

External references are used to describe pointers to information represented outside of CTIM. For example, a Malware object could use an external reference to indicate an ID for that malware in an external database or a report could use references to represent source material.

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[source_name](#propertysource_name-medstringstring)|MedString String|The source within which the external-reference is defined (system, registry, organization, etc.)|&#10003;|
|[description](#propertydescription-markdownstring)|Markdown String| ||
|[external_id](#propertyexternal_id-string)| String|An identifier for the external reference content.||
|[hashes](#propertyhashes-stringlist)| String List|Specifies a dictionary of hashes for the contents of the url.||
|[url](#propertyurl-string)| String|A URL reference to an external resource||

* Reference: [External Reference](https://docs.google.com/document/d/1dIrh1Lp3KAjEMm8o2VzAmuV0Peu-jt9aAh1IHrjAroM/pub#h.72bcfr3t79jx)

<a id="propertydescription-markdownstring"></a>
## Property description ∷ Markdown String

* This entry is optional


  * Markdown string with at most 5000 characters

<a id="propertyexternal_id-string"></a>
## Property external_id ∷  String

An identifier for the external reference content.

* This entry is optional



<a id="propertyhashes-stringlist"></a>
## Property hashes ∷  String List

Specifies a dictionary of hashes for the contents of the url.

* This entry is optional
* This entry's type is sequential (allows zero or more values)



<a id="propertysource_name-medstringstring"></a>
## Property source_name ∷ MedString String

The source within which the external-reference is defined (system, registry, organization, etc.)

* This entry is required


  * String with at most 2048 characters

<a id="propertyurl-string"></a>
## Property url ∷  String

A URL reference to an external resource

* This entry is optional


  * A URI

<a id="map2"></a>
# *CVE* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[cve_data_meta](#propertycve_data_meta-cvedatametaobject)|*CVEDataMeta* Object| |&#10003;|


<a id="propertycve_data_meta-cvedatametaobject"></a>
## Property cve_data_meta ∷ *CVEDataMeta* Object

* This entry is required


<a id="map4-ref"></a>
* *CVEDataMeta* Object Value
  * Details: [*CVEDataMeta* Object](#map4)

<a id="map4"></a>
# *CVEDataMeta* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[assigner](#propertyassigner-shortstringstring)|ShortString String| ||
|[id](#propertyid-shortstringstring)|ShortString String| ||


<a id="propertyassigner-shortstringstring"></a>
## Property assigner ∷ ShortString String

* This entry is optional


  * String with at most 1024 characters

<a id="propertyid-shortstringstring"></a>
## Property id ∷ ShortString String

* This entry is optional


  * String with at most 1024 characters

<a id="map3"></a>
# *VulnerabilityImpact* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[cvss_v3](#propertycvss_v3-cvssv3object)|*CVSSV3* Object| ||
|[exploitability_score](#propertyexploitability_score-number)|Number| ||
|[impact_score](#propertyimpact_score-number)|Number| ||


<a id="propertycvss_v3-cvssv3object"></a>
## Property cvss_v3 ∷ *CVSSV3* Object

* This entry is optional


<a id="map5-ref"></a>
* *CVSSV3* Object Value
  * Details: [*CVSSV3* Object](#map5)

<a id="propertyexploitability_score-number"></a>
## Property exploitability_score ∷ Number

* This entry is optional


  * a Score number from 0 to 10

<a id="propertyimpact_score-number"></a>
## Property impact_score ∷ Number

* This entry is optional


  * a Score number from 0 to 10

<a id="map5"></a>
# *CVSSV3* Object

| Property | Type | Description | Required? |
| -------- | ---- | ----------- | --------- |
|[base_score](#propertybase_score-number)|Number| |&#10003;|
|[base_severity](#propertybase_severity-vulnerabilityseveritystring)|VulnerabilitySeverity String| |&#10003;|
|[vector_string](#propertyvector_string-string)| String| |&#10003;|
|[attack_complexity](#propertyattack_complexity-vulnerabilityattackcomplexitystring)|VulnerabilityAttackComplexity String|describes the conditions beyond the attacker's control that must exist in order to exploit the vulnerability||
|[attack_vector](#propertyattack_vector-vulnerabilityattackvectorstring)|VulnerabilityAttackVector String|Reflects the context by which vulnerability exploitation is possible||
|[availability_impact](#propertyavailability_impact-vulnerabilityavailabilityimpactstring)|VulnerabilityAvailabilityImpact String|measures the impact to the availability of the impacted component resulting from a successfullyexploited vulnerability||
|[availability_requirement](#propertyavailability_requirement-vulnerabilitysecurityrequirementsstring)|VulnerabilitySecurityRequirements String| ||
|[confidentiality_impact](#propertyconfidentiality_impact-vulnerabilityconfidentialityimpactstring)|VulnerabilityConfidentialityImpact String|measures the impact to the confidentiality ofthe information resources managed by a software component due to a successfully exploited vulnerability||
|[confidentiality_requirement](#propertyconfidentiality_requirement-vulnerabilitysecurityrequirementsstring)|VulnerabilitySecurityRequirements String| ||
|[environmental_score](#propertyenvironmental_score-number)|Number| ||
|[environmental_severity](#propertyenvironmental_severity-vulnerabilityseveritystring)|VulnerabilitySeverity String| ||
|[exploit_code_maturity](#propertyexploit_code_maturity-vulnerabilityexploitcodematuritystring)|VulnerabilityExploitCodeMaturity String|measures the likelihood of the vulnerability being attacked||
|[integrity_impact](#propertyintegrity_impact-vulnerabilityintegrityimpactstring)|VulnerabilityIntegrityImpact String|measures the impact to integrity of a successfully exploited vulnerability||
|[integrity_requirement](#propertyintegrity_requirement-vulnerabilitysecurityrequirementsstring)|VulnerabilitySecurityRequirements String| ||
|[modified_attack_complexity](#propertymodified_attack_complexity-vulnerabilitymodifiedattackcomplexitystring)|VulnerabilityModifiedAttackComplexity String|modified attack complexity||
|[modified_attack_vector](#propertymodified_attack_vector-vulnerabilitymodifiedattackvectorstring)|VulnerabilityModifiedAttackVector String|modified attack vector||
|[modified_availability_impact](#propertymodified_availability_impact-vulnerabilitymodifiedavailabilityimpactstring)|VulnerabilityModifiedAvailabilityImpact String|modified availability impact||
|[modified_confidentiality_impact](#propertymodified_confidentiality_impact-vulnerabilitymodifiedconfidentialityimpactstring)|VulnerabilityModifiedConfidentialityImpact String|modified confidentiality impact||
|[modified_integrity_impact](#propertymodified_integrity_impact-vulnerabilitymodifiedintegrityimpactstring)|VulnerabilityModifiedIntegrityImpact String|modified integrity impact||
|[modified_privileges_required](#propertymodified_privileges_required-vulnerabilitymodifiedprivilegesrequiredstring)|VulnerabilityModifiedPrivilegesRequired String|modified privileges required||
|[modified_scope](#propertymodified_scope-vulnerabilitymodifiedscopestring)|VulnerabilityModifiedScope String|modified scope||
|[modified_user_interaction](#propertymodified_user_interaction-vulnerabilitymodifieduserinteractionstring)|VulnerabilityModifiedUserInteraction String|modified user interaction||
|[privileges_required](#propertyprivileges_required-vulnerabilityprivilegesrequiredstring)|VulnerabilityPrivilegesRequired String|describes the level of privileges an attacker must possess before successfully exploiting the vulnerability||
|[remediation_level](#propertyremediation_level-vulnerabilityremediationlevelstring)|VulnerabilityRemediationLevel String|Remediation Level of a vulnerability is an important factor for prioritization||
|[report_confidence](#propertyreport_confidence-vulnerabilityreportconfidencestring)|VulnerabilityReportConfidence String|measures the degree of confidence in the existence of the vulnerability and the credibility of the known technical details||
|[scope](#propertyscope-vulnerabilityscopestring)|VulnerabilityScope String|the ability for a vulnerability in one software component to impact resources beyond its means, or privileges||
|[temporal_score](#propertytemporal_score-number)|Number|Round up(VulnerabilityBaseScore × VulnerabilityExploitCodeMaturity × VulnerabilityRemediationLevel × VulnerabilityReportConfidence)||
|[temporal_severity](#propertytemporal_severity-number)|Number|temporal severity||
|[user_interaction](#propertyuser_interaction-vulnerabilityuserinteractionstring)|VulnerabilityUserInteraction String|captures the requirement for a user, other than the attacker, to participate in the successful compromise of the vulnerable component||


<a id="propertyattack_complexity-vulnerabilityattackcomplexitystring"></a>
## Property attack_complexity ∷ VulnerabilityAttackComplexity String

describes the conditions beyond the attacker's control that must exist in order to exploit the vulnerability

* This entry is optional


  * describes the conditions beyond the attacker's control that must exist in order to exploit the vulnerability. As described below, such conditions may require the collection of more information about the target, the presence of certain system configuration settings, or computational exceptions. Importantly, the assessment of this metric excludes any requirements for user interaction in order to exploit the vulnerability (such conditions are captured in the User Interaction metric). this metric value is largest for the least complex attacks. The list of possible values are: `low` Specialized access conditions or extenuating circumstances do not exist. An attacker can expect repeatable success against the vulnerable component. `high` A successful attack depends on conditions beyond the attacker's control. That is, a successful attack cannot be accomplished at will, but requires the attacker to invest in some measurable amount of effort in preparation or execution against the vulnerable component before a successful attack can be expected. For example, a successful attack may depend on an attacker overcoming any of the following conditions: - The attacker must conduct target-specific reconnaissance. For example, on target configuration settings, sequence numbers, shared secrets, etc. - The attacker must prepare the target environment to improve exploit reliability. For example, repeated exploitation to win a race condition, or overcoming advanced exploit mitigation techniques. The attacker must inject herself into the logical network path between the target and the resource requested by the victim in order to read and/or modify network communications (e.g. man in the middle attack).
  * Allowed Values:
    * high
    * low
  * Reference: [Attack Complexity](https://www.first.org/cvss/specification-document#2-1-2-Attack-Complexity-AC)

<a id="propertyattack_vector-vulnerabilityattackvectorstring"></a>
## Property attack_vector ∷ VulnerabilityAttackVector String

Reflects the context by which vulnerability exploitation is possible

* This entry is optional


  * This metric reflects the context by which vulnerability exploitation is possible. This metric value (and consequently the Base score) will be larger the more remote (logically, and physically) an attacker can be in order to exploit the vulnerable component. The assumption is that the number of potential attackers for a vulnerability that could be exploited from across the Internet is larger than the number of potential attackers that could exploit a vulnerability requiring physical access to a device, and therefore warrants a greater score. The list of possible values is: `network` A vulnerability exploitable with network access means the vulnerable component is bound to the network stack and the attacker's path is through OSI layer 3 (the network layer). Such a vulnerability is often termed `remotely exploitable` and can be thought of as an attack being exploitable one or more network hops away (e.g. across layer 3 boundaries from routers). An example of a network attack is an attacker causing a denial of service (DoS) by sending a specially crafted TCP packet from across the public Internet (e.g. CVE 2004 0230).`adjacent_network` A vulnerability exploitable with adjacent network access means the vulnerable component is bound to the network stack, however the attack is limited to the same shared physical (e.g. Bluetooth, IEEE 802.11) or logical (e.g. local IP subnet) network, and cannot be performed across an OSI layer 3 boundary (e.g. a router). An example of an Adjacent attack would be an ARP (IPv4) or neighbor discovery (IPv6) flood leading to a denial of service on the local LAN segment. See also CVE 2013 6014. `local` A vulnerability exploitable with Local access means that the vulnerable component is not bound to the network stack, and the attacker's path is via read/write/execute capabilities. In some cases, the attacker may be logged in locally in order to exploit the vulnerability, otherwise, she may rely on User Interaction to execute a malicious file. `physical` A vulnerability exploitable with Physical access requires the attacker to physically touch or manipulate the vulnerable component. Physical interaction may be brief (e.g. evil maid attack) or persistent. An example of such an attack is a cold boot attack which allows an attacker to access to disk encryption keys after gaining physical access to the system, or peripheral attacks such as Firewire/USB Direct Memory Access attacks.
  * Allowed Values:
    * adjacent_network
    * local
    * network
    * physical
  * Reference: [Attack Vector](https://www.first.org/cvss/specification-document#2-1-1-Attack-Vector-AV)

<a id="propertyavailability_impact-vulnerabilityavailabilityimpactstring"></a>
## Property availability_impact ∷ VulnerabilityAvailabilityImpact String

measures the impact to the availability of the impacted component resulting from a successfullyexploited vulnerability

* This entry is optional


  * This metric measures the impact to the availability of the impacted component resulting from a successfully exploited vulnerability. While the Confidentiality and Integrity impact metrics apply to the loss of confidentiality or integrity of data (e.g., information, files) used by the impacted component, this metric refers to the loss of availability of the impacted component itself, such as a networked service (e.g., web, database, email). Since availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of an impacted component. The list of possible values is presented is: `high`: There is total loss of availability, resulting in the attacker being able to fully deny access to resources in the impacted component; this loss is either sustained (while the attacker continues to deliver the attack) or persistent (the condition persists even after the attack has completed). Alternatively, the attacker has the ability to deny some availability, but the loss of availability presents a direct, serious consequence to the impacted component (e.g., the attacker cannot disrupt existing connections, but can prevent new connections; the attacker can repeatedly exploit a vulnerability that, in each instance of a successful attack, leaks a only small amount of memory, but after repeated exploitation causes a service to become completely unavailable). `low`: There is reduced performance or interruptions in resource availability. Even if repeated exploitation of the vulnerability is possible, the attacker does not have the ability to completely deny service to legitimate users. The resources in the impacted component are either partially available all of the time, or fully available only some of the time but overall there is no direct, serious consequence to the impacted component. `none`: There is no impact to availability within the impacted component. This metric value increases with the consequence to the impacted component.
  * Allowed Values:
    * high
    * low
    * none
  * Reference: [Availability Impact] (https://www.first.org/cvss/specification-document#2-3-3-Availability-Impact-A)

<a id="propertyavailability_requirement-vulnerabilitysecurityrequirementsstring"></a>
## Property availability_requirement ∷ VulnerabilitySecurityRequirements String

* This entry is optional


  * These metrics enable the analyst to customize the CVSS score depending on the importance of the affected IT asset to a user's organization, measured in terms of Confidentiality, Integrity, and Availability. That is, if an IT asset supports a business function for which Availability is most important, the analyst can assign a greater value to Availability relative to Confidentiality and Integrity. Each security requirement has three possible values: Low, Medium, or High. The full effect on the environmental score is determined by the corresponding Modified Base Impact metrics. That is, these metrics modify the environmental score by reweighting the Modified Confidentiality, Integrity, and Availability impact metrics. For example, the Modified Confidentialityimpact (MC) metric has increased weight if the Confidentiality Requirement (CR) is High. Likewise, the Modified Confidentiality impact metric has decreased weight if the Confidentiality Requirement is Low. The Modified Confidentiality impact metric weighting is neutral if the Confidentiality Requirement is Medium. This same process is applied to the Integrity and Availability requirements.Note that the Confidentiality Requirement will not affect the Environmental score if the (Modified Base) confidentiality impact is set to None. Also, increasing the Confidentiality Requirement from Medium to Highwill not change the Environmental score when the (Modified Base) impact metrics are set to High. This is because the modified impact sub score (part of the Modified Base score that calculates impact) is already at a maximum value of 10. The list of possible values is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to the equation to skip this metric. `high`: Loss of [Confidentiality / Integrity / Availability] is likely to have a catastrophic adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). `medium`: Loss of [Confidentiality / Integrity / Availability] is likely to have a serious adverse effect on the organization or individuals associated with the organization (e.g., employees, customers).`low`: Loss of [Confidentiality / Integrity / Availability] is likely to have only a limited adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). For brevity, the same table is used for all three metrics. The greater the Security Requirement, the higher the score (recall that Medium is considered the default).
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Security Requirements] (https://www.first.org/cvss/specification-document#4-1-Security-Requirements-CR-IR-AR)

<a id="propertybase_score-number"></a>
## Property base_score ∷ Number

* This entry is required


  * a Score number from 0 to 10

<a id="propertybase_severity-vulnerabilityseveritystring"></a>
## Property base_severity ∷ VulnerabilitySeverity String

* This entry is required


  * Allowed Values:
    * critical
    * high
    * low
    * medium
    * none

<a id="propertyconfidentiality_impact-vulnerabilityconfidentialityimpactstring"></a>
## Property confidentiality_impact ∷ VulnerabilityConfidentialityImpact String

measures the impact to the confidentiality ofthe information resources managed by a software component due to a successfully exploited vulnerability

* This entry is optional


  * measures the impact to the confidentiality of the information resources managed by a software component due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, as well as preventing access by, or disclosure to, unauthorized ones. The list of possible values  is: `high`: There is total loss of confidentiality, resulting in all resources within the impacted component being divulged to the attacker. Alternatively, access to only some restricted information is obtained, but the disclosed information presents a direct, serious impact. For example, an attacker steals the administrator's password, or private encryption keys of a web server. `low`: There is some loss of confidentiality. Access to some restricted information is obtained, but the attacker does not have control over what information is obtained, or the amount or kind of loss is constrained. The information disclosure does not cause a direct, serious loss to the impacted component. `none`: There is no loss of confidentiality within the impacted component. This metric value increases with the degree of loss to the impacted component.
  * Allowed Values:
    * high
    * low
    * none
  * Reference: [Confientiality Impact] (https://www.first.org/cvss/specification-document#2-3-1-Confidentiality-Impact-C)

<a id="propertyconfidentiality_requirement-vulnerabilitysecurityrequirementsstring"></a>
## Property confidentiality_requirement ∷ VulnerabilitySecurityRequirements String

* This entry is optional


  * These metrics enable the analyst to customize the CVSS score depending on the importance of the affected IT asset to a user's organization, measured in terms of Confidentiality, Integrity, and Availability. That is, if an IT asset supports a business function for which Availability is most important, the analyst can assign a greater value to Availability relative to Confidentiality and Integrity. Each security requirement has three possible values: Low, Medium, or High. The full effect on the environmental score is determined by the corresponding Modified Base Impact metrics. That is, these metrics modify the environmental score by reweighting the Modified Confidentiality, Integrity, and Availability impact metrics. For example, the Modified Confidentialityimpact (MC) metric has increased weight if the Confidentiality Requirement (CR) is High. Likewise, the Modified Confidentiality impact metric has decreased weight if the Confidentiality Requirement is Low. The Modified Confidentiality impact metric weighting is neutral if the Confidentiality Requirement is Medium. This same process is applied to the Integrity and Availability requirements.Note that the Confidentiality Requirement will not affect the Environmental score if the (Modified Base) confidentiality impact is set to None. Also, increasing the Confidentiality Requirement from Medium to Highwill not change the Environmental score when the (Modified Base) impact metrics are set to High. This is because the modified impact sub score (part of the Modified Base score that calculates impact) is already at a maximum value of 10. The list of possible values is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to the equation to skip this metric. `high`: Loss of [Confidentiality / Integrity / Availability] is likely to have a catastrophic adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). `medium`: Loss of [Confidentiality / Integrity / Availability] is likely to have a serious adverse effect on the organization or individuals associated with the organization (e.g., employees, customers).`low`: Loss of [Confidentiality / Integrity / Availability] is likely to have only a limited adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). For brevity, the same table is used for all three metrics. The greater the Security Requirement, the higher the score (recall that Medium is considered the default).
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Security Requirements] (https://www.first.org/cvss/specification-document#4-1-Security-Requirements-CR-IR-AR)

<a id="propertyenvironmental_score-number"></a>
## Property environmental_score ∷ Number

* This entry is optional


  * a Score number from 0 to 10

<a id="propertyenvironmental_severity-vulnerabilityseveritystring"></a>
## Property environmental_severity ∷ VulnerabilitySeverity String

* This entry is optional


  * Allowed Values:
    * critical
    * high
    * low
    * medium
    * none

<a id="propertyexploit_code_maturity-vulnerabilityexploitcodematuritystring"></a>
## Property exploit_code_maturity ∷ VulnerabilityExploitCodeMaturity String

measures the likelihood of the vulnerability being attacked

* This entry is optional


  * This metric measures the likelihood of the vulnerability being attacked, and is typically based on the current state of exploit techniques, exploit code availability, or active, 'in-the-wild' exploitation. Public availability of easy-to-use exploit code increases the number of potential attackers by including those who are unskilled, thereby increasing the severity of the vulnerability. Initially, real-world exploitation may only be theoretical. Publication of proof-of-concept code, functional exploit code, or sufficient technical details necessary to exploit the vulnerability may follow. Furthermore, the exploit code available may progress from a proof-of-concept demonstration to exploit code that is successful in exploiting the vulnerability consistently. In severe cases, it may be delivered as the payload of a network-based worm or virus or other automated attack tools. The list of possible values is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to a scoring equation to skip this metric. `high`: Functional autonomous code exists, or no exploit is required (manual trigger) and details are widely available. Exploit code works in every situation, or is actively being delivered via an autonomous agent (such as a worm or virus). Network-connected systems are likely to encounter scanning or exploitation attempts. Exploit development has reached the level of reliable, widely-available, easy-to-use automated tools. `functional`: Functional exploit code is available. The code works in most situations where the vulnerability exists. `proof_of_concept`: Proof-of-concept exploit code is available, or an attack demonstration is not practical for most systems. The code or technique is not functional in all situations and may require substantial modification by a skilled attacker. `unproven`: No exploit code is available, or an exploit is theoretical.
  * Allowed Values:
    * functional
    * high
    * not_defined
    * proof_of_concept
    * unproven
  * Reference: [Exploit Code Maturity] (https://www.first.org/cvss/specification-document#3-1-Exploit-Code-Maturity-E)

<a id="propertyintegrity_impact-vulnerabilityintegrityimpactstring"></a>
## Property integrity_impact ∷ VulnerabilityIntegrityImpact String

measures the impact to integrity of a successfully exploited vulnerability

* This entry is optional


  * This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information. The list of possible values  is: `high`: There is a total loss of integrity, or a complete loss of protection. For example, the attacker is able to modify any/all files protected by the impacted component. Alternatively, only some files can be modified, but malicious modification would present a direct, serious consequence to the impacted component. `low`: Modification of data is possible, but the attacker does not have control over the consequence of a modification, or the amount of modification is constrained. The data modification does not have a direct, serious impact on the impacted component.`none`: There is no loss of integrity within the impacted component.this metric value increases with the consequence to the impacted component. 
  * Allowed Values:
    * high
    * low
    * none
  * Reference: [Integrity Impact] (https://www.first.org/cvss/specification-document#2-3-2-Integrity-Impact-I)

<a id="propertyintegrity_requirement-vulnerabilitysecurityrequirementsstring"></a>
## Property integrity_requirement ∷ VulnerabilitySecurityRequirements String

* This entry is optional


  * These metrics enable the analyst to customize the CVSS score depending on the importance of the affected IT asset to a user's organization, measured in terms of Confidentiality, Integrity, and Availability. That is, if an IT asset supports a business function for which Availability is most important, the analyst can assign a greater value to Availability relative to Confidentiality and Integrity. Each security requirement has three possible values: Low, Medium, or High. The full effect on the environmental score is determined by the corresponding Modified Base Impact metrics. That is, these metrics modify the environmental score by reweighting the Modified Confidentiality, Integrity, and Availability impact metrics. For example, the Modified Confidentialityimpact (MC) metric has increased weight if the Confidentiality Requirement (CR) is High. Likewise, the Modified Confidentiality impact metric has decreased weight if the Confidentiality Requirement is Low. The Modified Confidentiality impact metric weighting is neutral if the Confidentiality Requirement is Medium. This same process is applied to the Integrity and Availability requirements.Note that the Confidentiality Requirement will not affect the Environmental score if the (Modified Base) confidentiality impact is set to None. Also, increasing the Confidentiality Requirement from Medium to Highwill not change the Environmental score when the (Modified Base) impact metrics are set to High. This is because the modified impact sub score (part of the Modified Base score that calculates impact) is already at a maximum value of 10. The list of possible values is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to the equation to skip this metric. `high`: Loss of [Confidentiality / Integrity / Availability] is likely to have a catastrophic adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). `medium`: Loss of [Confidentiality / Integrity / Availability] is likely to have a serious adverse effect on the organization or individuals associated with the organization (e.g., employees, customers).`low`: Loss of [Confidentiality / Integrity / Availability] is likely to have only a limited adverse effect on the organization or individuals associated with the organization (e.g., employees, customers). For brevity, the same table is used for all three metrics. The greater the Security Requirement, the higher the score (recall that Medium is considered the default).
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Security Requirements] (https://www.first.org/cvss/specification-document#4-1-Security-Requirements-CR-IR-AR)

<a id="propertymodified_attack_complexity-vulnerabilitymodifiedattackcomplexitystring"></a>
## Property modified_attack_complexity ∷ VulnerabilityModifiedAttackComplexity String

modified attack complexity

* This entry is optional


  * The same values as Attack Complexity, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * high
    * low
    * not_defined
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_attack_vector-vulnerabilitymodifiedattackvectorstring"></a>
## Property modified_attack_vector ∷ VulnerabilityModifiedAttackVector String

modified attack vector

* This entry is optional


  * The same values as Attack Vector, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * adjacent_network
    * local
    * network
    * not_defined
    * physical
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_availability_impact-vulnerabilitymodifiedavailabilityimpactstring"></a>
## Property modified_availability_impact ∷ VulnerabilityModifiedAvailabilityImpact String

modified availability impact

* This entry is optional


  * The same values as Availability Impact, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_confidentiality_impact-vulnerabilitymodifiedconfidentialityimpactstring"></a>
## Property modified_confidentiality_impact ∷ VulnerabilityModifiedConfidentialityImpact String

modified confidentiality impact

* This entry is optional


  * The same values as Confidentiality Impact, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_integrity_impact-vulnerabilitymodifiedintegrityimpactstring"></a>
## Property modified_integrity_impact ∷ VulnerabilityModifiedIntegrityImpact String

modified integrity impact

* This entry is optional


  * The same values as Integrity Impact, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_privileges_required-vulnerabilitymodifiedprivilegesrequiredstring"></a>
## Property modified_privileges_required ∷ VulnerabilityModifiedPrivilegesRequired String

modified privileges required

* This entry is optional


  * The same values as Privileges Required, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * high
    * low
    * none
    * not_defined
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_scope-vulnerabilitymodifiedscopestring"></a>
## Property modified_scope ∷ VulnerabilityModifiedScope String

modified scope

* This entry is optional


  * The same values as Scope, as well as not_defined (the default)
  * Default: not_defined
  * Allowed Values:
    * changed
    * not_defined
    * unchanged
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertymodified_user_interaction-vulnerabilitymodifieduserinteractionstring"></a>
## Property modified_user_interaction ∷ VulnerabilityModifiedUserInteraction String

modified user interaction

* This entry is optional


  * The same values as User Interaction, as well as not_defined (the default)
  * Allowed Values:
    * none
    * not_defined
    * required
  * Reference: [Modified Base Metrics] (https://www.first.org/cvss/specification-document#4-2-Modified-Base-Metrics)

<a id="propertyprivileges_required-vulnerabilityprivilegesrequiredstring"></a>
## Property privileges_required ∷ VulnerabilityPrivilegesRequired String

describes the level of privileges an attacker must possess before successfully exploiting the vulnerability

* This entry is optional


  * This metric describes the level of privileges an attacker must possess before successfully exploiting the vulnerability. This metric is greatest if no privileges are required. The list of possible values is: `none`: The attacker is unauthorized prior to attack, and therefore does not require any access to settings or files to carry out an attack. `low`: The attacker is authorized with (i.e. requires) privileges that provide basic user capabilities that could normally affect only settings and files owned by a user. Alternatively, an attacker with Low privileges may have the ability to cause an impact only to non-sensitive resources. `high`: The attacker is authorized with (i.e. requires) privileges that provide significant (e.g. administrative) control over the vulnerable component that could affect component-wide settings and files.
  * Allowed Values:
    * high
    * low
    * none
  * Reference: [Privileges Required] (https://www.first.org/cvss/specification-document#2-1-3-Privileges-Required-PR)

<a id="propertyremediation_level-vulnerabilityremediationlevelstring"></a>
## Property remediation_level ∷ VulnerabilityRemediationLevel String

Remediation Level of a vulnerability is an important factor for prioritization

* This entry is optional


  * The Remediation Level of a vulnerability is an important factor for prioritization. The typical vulnerability is unpatched when initially published. Workarounds or hotfixes may offer interim remediation until an official patch or upgrade is issued. Each of these respective stages adjusts the temporal score downwards, reflecting the decreasing urgency as remediation becomes final. The list of possible values is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to a scoring equation to skip this metric. `unavailable`: There is either no solution available or it is impossible to apply. `workaround`: There is an unofficial, non-vendor solution available. In some cases, users of the affected technology will create a patch of their own or provide steps to work around or otherwise mitigate the vulnerability. `temporary_fix`: There is an official but temporary fix available. This includes instances where the vendor issues a temporary hotfix, tool, or workaround.`official_fix`: A complete vendor solution is available. Either the vendor has issued an official patch, or an upgrade is available. The less official and permanent a fix, the higher the vulnerability score. 
  * Allowed Values:
    * high
    * not_defined
    * offical_fix
    * temporary_fix
    * unavailable
    * workaround
  * Reference: [Remediation Level] (https://www.first.org/cvss/specification-document#3-2-Remediation-Level-RL)

<a id="propertyreport_confidence-vulnerabilityreportconfidencestring"></a>
## Property report_confidence ∷ VulnerabilityReportConfidence String

measures the degree of confidence in the existence of the vulnerability and the credibility of the known technical details

* This entry is optional


  * measures the degree of confidence in the existence of the vulnerability and the credibility of the known technical details. Sometimes only the existence of vulnerabilities are publicized, but without specific details. For example, an impact may be recognized as undesirable, but the root cause may not be known. The vulnerability may later be corroborated by research which suggests where the vulnerability may lie, though the research may not be certain. Finally, a vulnerability may be confirmed through acknowledgement by the author or vendor of the affected technology. The urgency of a vulnerability is higher when a vulnerability is known to exist with certainty. This metric also suggests the level of technical knowledge available to would-be attackers. The list of possible values  is: `not_defined`: Assigning this value to the metric will not influence the score. It is a signal to a scoring equation to skip this metric. `confirmed`: Detailed reports exist, or functional reproduction is possible (functional exploits may provide this). Source code is available to independently verify theassertions of the research, or the author or vendor of the affected code has confirmed the presence of the vulnerability. `reasonable`: Significant details are published, but researchers either do not have full confidence in the root cause, or do not have access to source code to fully confirm all of the interactions that may lead to the result. Reasonable confidence exists, however, that the bug is reproducible and at least one impact is able to be verified (proof-of-concept exploits may provide this). An example is a detailed write-up of research into a vulnerability with an explanation (possibly obfuscated or 'left as an exercise to the reader') that gives assurances on how to reproduce the results. `unknown`: There are reports of impacts that indicate a vulnerability is present. The reports indicate that the cause of the vulnerability is unknown, or reports may differ on the cause or impacts of the vulnerability. Reporters are uncertain of the true nature of the vulnerability, and there is little confidence in the validity of the reports or whether a static Base score can be applied given the differences described. An example is a bug report which notes that an intermittent but non-reproducible crash occurs, with evidence of memory corruption suggesting that denial of service, or possible more serious impacts, may result. The more a vulnerability is validated by the vendor or other reputable sources, the higher the score.
  * Allowed Values:
    * confirmed
    * reasonable
    * unknown
  * Reference: [Report Confidence] (https://www.first.org/cvss/specification-document#3-3-Report-Confidence-RC)

<a id="propertyscope-vulnerabilityscopestring"></a>
## Property scope ∷ VulnerabilityScope String

the ability for a vulnerability in one software component to impact resources beyond its means, or privileges

* This entry is optional


  * An important property captured by CVSS v3.0 is the ability for a vulnerability in one software component to impact resources beyond its means, or privileges. This consequence is represented by the metric Authorization Scope, or simply Scope. Formally, Scope refers to the collection of privileges defined by a computing authority (e.g. an application, an operating system, or a sandbox environment) when granting access to computing resources (e.g. files, CPU, memory, etc). These privileges are assigned based on some method of identification and authorization. In some cases, the authorization may be simple or loosely controlled based upon predefined rules or standards. For example, in the case of Ethernet traffic sent to a network switch, the switch accepts traffic that arrives on its ports and is an authority that controls the traffic flow to other switch ports. When the vulnerability of a software component governed by one authorization scope is able to affect resources governed by another authorization scope, a Scope change has occurred. Intuitively, one may think of a scope change as breaking out of a sandbox, and an example would be a vulnerability in a virtual machine that enables an attacker to delete files on the host OS (perhaps even its own VM). In this example, there are two separate authorization authorities: one that defines and enforces privileges for the virtual machine and its users, and one that defines and enforces privileges for the host system within which the virtual machine runs. a scope change would not occur, for example, with a vulnerability in Microsoft Word that allows an attacker to compromise all system files of the host OS, because the same authority enforces privileges of the user's instance of Word, and the host's system files. The Base score is greater when a scope change has occurred. The list of possible values is: `unchanged`: An exploited vulnerability can only affect resources managed by the same authority. In this case the vulnerable component and the impacted component are the same. `changed`: An exploited vulnerability can affect resources beyond the authorization privileges intended by the vulnerable component. In this case the vulnerable component and the impacted component are different.
  * Allowed Values:
    * changed
    * unchanged
  * Reference: [Scope] (https://www.first.org/cvss/specification-document#2-2-Scope-S)

<a id="propertytemporal_score-number"></a>
## Property temporal_score ∷ Number

Round up(VulnerabilityBaseScore × VulnerabilityExploitCodeMaturity × VulnerabilityRemediationLevel × VulnerabilityReportConfidence)

* This entry is optional


  * a Score number from 0 to 10

<a id="propertytemporal_severity-number"></a>
## Property temporal_severity ∷ Number

temporal severity

* This entry is optional


  * a Score number from 0 to 10

<a id="propertyuser_interaction-vulnerabilityuserinteractionstring"></a>
## Property user_interaction ∷ VulnerabilityUserInteraction String

captures the requirement for a user, other than the attacker, to participate in the successful compromise of the vulnerable component

* This entry is optional


  * captures the requirement for a user, other than the attacker, to participate in the successful compromise of the vulnerable component. This metric determines whether the vulnerability can be exploited solely at the will of the attacker, or whether a separate user (or user-initiated process) must participate in some manner. This metric value is greatest when no user interaction is required. The list of possible values is: `none`: The vulnerable system can be exploited without interaction from any user. `required`: Successful exploitation of this vulnerability requires a user to take some action before the vulnerability can be exploited. For example, a successful exploit may only be possible during the installation of an application by a system administrator.
  * Allowed Values:
    * none
    * required
  * Reference: [User Interaction] (https://www.first.org/cvss/specification-document#2-1-4-User-Interaction-UI)

<a id="propertyvector_string-string"></a>
## Property vector_string ∷  String

* This entry is required


  * a text representation of a set of CVSS metrics.It is commonly used to record or transfer CVSS metric information in a concise form
