(ns ctim.rdf.parser.sighting
  (:require [ctim.rdf.parser.common :as c]))

(defn relation->rdf
  [id
   {:keys [origin origin_uri relation source related]
    :or [origin_uri c/default-graph]}]
  (let [b-node (c/blank-node)])
  [{:s id
    :p :ctio/relation
    :v b-node
    :g origin_uri}
   {:s origin_uri
    :p :rdfs/label
    :v origin
    :g c/default-graph}]
  )

(defn relations->rdf
  [id relations]
  (map #(relation->rdf id %) relations))
