(ns ctim.examples.malwares
  (:require [ctim.schemas.common :as c]))

(def malware-maximal
  {:id "http://ex.tld/ctia/malware/malware-616608f4-7658-49f1-8728-d9a3dde849d5"
   :type "malware"
   :schema_version c/ctim-schema-version
   :revision 1
   :external_ids ["http://ex.tld/ctia/malware/cisco-malware-616608f4-7658-49f1-8728-d9a3dde849d5"
                  "http://ex.tld/ctia/malware/mitre-malware--c0c45d38-fe57-4cd4-b2b2-9ecd0ddd4ca9"]
   :external_references
   [{:source_name "Cylance Cleaver"
     :external_id "S0004"
     :url "http://www.cylance.com/assets/Cleaver/Cylance%20Operation%20Cleaver%20Report.pdf"
     :description "Cylance. (2014, December). Operation Cleaver. Retrieved December 4, 2014."
     :hashes ["#section1"]}]
   :timestamp #inst "2016-05-11T00:40:48.212-00:00"
   :language "language"
   :tlp "green"
   :source "source"
   :source_uri "http://example.com"
   :labels ["malware"]
   :title "TinyZBot"
   :description "TinyZBot is a bot written in C# that was developed by Cleaver."
   :short_description "A bot developed by Cleaver."
   :kill_chain_phases [{:kill_chain_name "mitre-attack"
                        :phase_name "persistence"}]
   :x_mitre_aliases ["KleinZBot"]
   :abstraction_level "variant"})

(def malware-minimal
  {:id "http://ex.tld/ctia/malware/malware-616608f4-7658-49f1-8728-d9a3dde849d5"
   :type "malware"
   :schema_version c/ctim-schema-version
   :title "TinyZBot"
   :description "TinyZBot is a bot written in C# that was developed by Cleaver."
   :short_description "A bot developed by Cleaver."
   :labels ["malware"]})

(def new-malware-maximal
  malware-maximal)

(def new-malware-minimal
  {:title "TinyZBot"
   :description "TinyZBot is a bot written in C# that was developed by Cleaver."
   :short_description "A bot developed by Cleaver."
   :labels ["malware"]})
