(ns leiningen.trim-sl4j-classpath)

(defn trim [coordinate]
  {:pre [(vector? coordinate)
         (not (vector? (first coordinate)))]}
  (let [coordinate (cond-> coordinate
                     (not (some #{:exclusions} coordinate))
                     (conj :exclusions []))]
    (->> coordinate

         (reduce (fn [{:keys [found? result]} x]
                   (if found?
                     {:found? false
                      :result (conj result
                                    (conj x
                                          ['ch.qos.logback/logback-classic]
                                          ['puppetlabs/trapperkeeper]
                                          ['puppetlabs/trapperkeeper-webserver-jetty9]
                                          ['org.slf4j/slf4j-log4j12]
                                          ['org.slf4j/slf4j-nop]))}
                     {:found? (= x :exclusions)
                      :result (conj result x)}))
                 {:found? false
                  :result []})

         :result)))

(defn middleware [project]
  (let [pred (fn [x]
               (or (-> x first #{'ch.qos.logback/logback-classic
                                 'org.slf4j/slf4j-log4j12
                                 'org.slf4j/slf4j-nop})
                   (and (-> x first #{'puppetlabs/trapperkeeper
                                      'puppetlabs/trapperkeeper-webserver-jetty9})
                        (or (-> x count (< 3))
                            (->> x (not-any? #{:classifier}))))))]
    
    (-> project
        (update :dependencies (partial mapv trim))
        (update :dependencies (partial remove pred))
        (update :managed-dependencies (partial mapv trim))
        (update :managed-dependencies (partial remove pred)))))
