(ns leiningen.new.thruster
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files sanitize-ns project-name]]
            [leiningen.core.main :as main]))

(def render (renderer "thruster"))

(defn thruster
  "Generate a new Pedestal/Om Web Development Project"
  [name]
  (let [sanitized-ns (sanitize-ns name)
        data {:raw-name      name
              :name          (project-name name)
              :namespace     sanitized-ns
              :sanitized     (name-to-path sanitized-ns)
              :namespace-set (str "'#{" namespace "}")}]
    (main/info "Generating fresh 'lein new' thruster project.")
    (->files data
             ;; Pedestal
             ["src/clj/{{sanitized}}.clj"               (render "service.clj" data)]
             ["src/clj/{{sanitized}}/routes.clj"        (render "routes.clj" data)]
             ["src/clj/{{sanitized}}/db.clj"            (render "db.clj" data)]
             ["test/clj/{{sanitized}}_test.clj"         (render "service_test.clj" data)]
             ["test/clj/{{sanitized}}/test_helpers.clj" (render "test_helpers.clj" data)]
             ["config/logback.xml"                      (render "logback.xml" data)]
             ;; Om
             ["src/cljs/{{sanitized}}/app.cljs"       (render "app.cljs" data)]
             ["resources/js/app.cljs.edn"             (render "app.cljs.edn" data)]
             ["test/cljs/{{sanitized}}/app_test.cljs" (render "app_test.cljs" data)]
             ;; Thruster
             ["README.md"  (render "README.md" data)]
             ["build.boot" (render "build.boot" data)]
             [".gitignore" (render ".gitignore" data)])))
