(ns tiesql.core-tracking
  (:require [clojure.core.async :as async :refer [<! >! <!! chan alt! go go-loop onto-chan sliding-buffer]]
            [tiesql.common :refer :all]))


(defonce tracking-fns (atom {}))
(defonce tracking-keys [sql-key error-key exec-time-key])


(defn start-tracking
  [name callback]
  {:pre [(keyword? name)
         (fn? callback)]}
  (swap! tracking-fns assoc-in [name] callback)
  nil)


(defn stop-tracking
  [name]
  {:pre [(keyword? name)]}
  (swap! tracking-fns #(dissoc % name))
  nil)


(defn stop-all-tracking
  []
  (reset! tracking-fns {})
  nil)


(defn warp-async-tracking
  [tm-coll tracking-fns t-keys]
  (do
    (go
      (if (< 0 (count tracking-fns))
        (let [r (if (map? tm-coll)
                  [tm-coll]
                  tm-coll)
              p (map #(select-keys % t-keys))
              v (into [] p r)]
          (doseq [t-fn tracking-fns]
            (t-fn v)))))
    tm-coll))
