(ns tiesql.core-util
  (:require [clj-common :as cc]
            [tiesql.common :refer :all]
            [tiesql.impl.join-impl :as j]
            ))


(defn validate-name!
  [tm name-coll]
  (let [skey (into #{} (keys tm))
        op-key (into #{} name-coll)]
    (if (clojure.set/superset? skey op-key)
      tm
      (->> (clojure.set/difference op-key skey)
           (first)
           (str "Name not found ")
           (cc/fail)))))


(defn validate-model!
  [tm-coll]
  (let [model-coll (mapv model-key tm-coll)
        m (distinct model-coll)]
    (if (not= (count model-coll)
              (count m))
      (cc/fail (str "Selecting duplicate model " model-coll))
      tm-coll)))



(defn filter-join-key
  [coll]
  (let [model-key-coll (mapv model-key coll)
        p (comp
            (cc/xf-skip-type #(= dml-type-call-key (dml-type-key %)))
            (map #(update-in % [join-key] j/filter-join-key-coll model-key-coll)))]
    (transduce p conj [] coll)))


(defn is-reserve?
  [tms coll]
  (if (->> (clojure.set/intersection
             (into #{} coll)
             (get-in tms [global-key reserve-name-key]))
           (not-empty))
    true
    false))


(defn has-dml-type? [m-map]
  (let [dml (dml-type-key m-map)]
    (or
      (= dml-type-update-key dml)
      (= dml-type-call-key dml)
      (= dml-type-insert-key dml)
      (= dml-type-delete-key dml)
      (= dml-type-select-key dml))))


(defn commit-type
  "Return commit type if not found return commit-none-key  "
  [tm-coll]
  (let [p (comp
            (filter #(not= dml-type-select-key (dml-type-key %)))
            (map #(commit-key %))
            (map #(or % commit-all-key)))
        commits (into [] p tm-coll)]
    ;(println commits)
    (if (empty? commits)
      commit-none-key
      (or (some #{commit-none-key} commits)
          (some #{commit-all-key} commits)
          (cc/contain-all? commits commit-any-key)
          commit-none-key))))


#_(defn commit?
    "Return commit type "
    [commit-type read-only? v]
    (if (or read-only?
            (cc/failed? v))
      false
      true))


(defn read-only?
  "Is it read only"

  ([tx-map]
   (if (contains? tx-map :read-only?)
     (:read-only? tx-map)
     true)
    #_(let [r? (if (contains? tx-map :read-only?)
                 (:read-only? tx-map)
                 true)]
        (if r?
          r?
          (= commit-type commit-none-key)))))



(defn assoc-single-key
  []
  {:assoc-single-key
   {k-process-type input-key
    k-name         :assoc-single-key
    k-order        9
    k-process      (map (fn [m]
                          (-> m
                              (assoc model-key (name-key m))
                              (assoc result-key #{result-single-key result-array-key})
                              ;(assoc result-key #{result-single-key })
                              (assoc dml-type-key dml-type-select-key))))
    }})


(defn map-single-key-result
  [m]
  (if (cc/failed? m)
    m
    (-> (vals m)
        (first)
        (get-in [1 0]))))


(defn map-result
  [m]
  (if (cc/failed? m)
    m
    (-> (vals m)
        (first))))



(defn s-pprint [order]
  {:pprint {k-name         :pprint
            k-order        order
            k-process-type input-key
            k-process      (map (fn [v]
                                  (do
                                    (debug v)

                                    v)
                                  ))}})
