(ns tiesql.impl.join-impl
  (:require [schema.core :as s]
            [schema.macros :as sm]
            [schema.utils :as su]
            [clj-common :as cc]
            [tiesql.common :refer :all]
            [tiesql.compiler.schema :as sch]
            ))


(defn get-source-relational-key-value
  [data-m j-coll]
  (reduce (fn [acc j1]
            (let [[s st rel _ dt [_ sdt _]] j1
                  w (keys (cc/group-by-value st (s data-m)))]
              (if (= rel join-n-n-key)
                (merge acc {sdt w})
                (merge acc {dt w})))
            ) {} j-coll))


(defn group-by-target-entity-key-one
  ""
  [[_ _ rel d dt [n nst _]] data-m]
  (if (= rel join-n-n-key)
    {d {nst (cc/group-by-value nst (get data-m n))}}
    {d {dt (cc/group-by-value dt (get data-m d))}}))



(defn group-by-target-entity-key-batch
  [j-coll data]
  (reduce (fn [acc j]
            (->> (group-by-target-entity-key-one j data)
                 (merge-with merge acc))
            ) {} j-coll))



(defn get-target-relational-key-value
  [target-rel-data-m data-m [s st rel d dt [_ nst _]]]
  (let [s-value (get-in data-m (conj s st))]
    (if (= join-n-n-key rel)
      (get-in target-rel-data-m [d nst s-value])
      (get-in target-rel-data-m [d dt s-value]))))



(defn assoc-to-source-entity-batch
  [target-rel-data-m data-m j-coll]
  (reduce (fn [acc [s _ _ d :as j]]
            (->> (get-target-relational-key-value target-rel-data-m data-m j)
                 (assoc-in acc (conj s d)))
            ) data-m j-coll))



(defn replace-source-entity-path
  [j-coll data-m]
  (for [[g-key coll] (group-by first j-coll)
        j coll
        em (cc/get-path data-m g-key)]
    (assoc j 0 em)))


(defn replace-target-entity-path
  [j-coll data-m]
  (for [[s-tab-id _ _ d-tab-id _ :as j] j-coll
        :let [w (conj s-tab-id d-tab-id)]
        :when (get-in data-m w)
        c (cc/get-path data-m [s-tab-id] d-tab-id)]
    (assoc j 3 c)))


(defn select-root
  [j-data j-coll]
  (select-keys j-data [(get-in j-coll [0 0])]))


(defn- is-join-skip?
  [join data]
  (let [root (get-in join [0 0])]
    (if (or (nil? join)
            (empty? join)
            (empty? (root data))
            (and (not (map? (root data)))
                 (sequential? (first (root data)))))
      true false)))


(defn do-join
  " do data join "
  [j-coll data]
  (if (is-join-skip? j-coll data)
    data
    (-> j-coll
        (group-by-target-entity-key-batch data)
        (assoc-to-source-entity-batch data (replace-source-entity-path j-coll data))
        (select-root j-coll))))


(defn split-join-n-n-key
  [j-coll]
  (split-with (fn [[_ _ rel]]
                (if (= rel join-n-n-key)
                  true
                  false))
              j-coll))


(defn group-by-target-entity-one
  [data j]
  (if (= join-n-n-key (nth j 2))
    (let [[st stc _ dt dtc [rdt s d]] j]
      {rdt [{s (get-in data (conj st stc))
             d (get-in data (conj dt dtc))}]})
    (let [[s _ _ d] j
          tdata (get-in data (conj s d))]
      {d (cc/as-sequential tdata)})))


(defn group-by-target-entity-batch
  [join-coll data]
  (->> join-coll
       (map #(group-by-target-entity-one data %))
       (apply merge-with (comp vec distinct concat))))


(defn assoc-target-entity-key
  [data j]
  (let [[s-tab s _ d-tab d] j
        s-ks (conj s-tab s)
        d-ks (conj d-tab d)]
    (if (map? (get-in data d-tab))
      (assoc-in data d-ks (get-in data s-ks))
      data)))



(defn do-disjoin
  "Assoc relation key and dis-join relation model "
  [join-coll data]
  (let [join-coll (replace-source-entity-path join-coll data)
        [n-join join] (split-join-n-n-key join-coll)

        ;Find n-n relation data
        nj-data (if (empty? n-join)
                  {}
                  (-> n-join
                      (replace-target-entity-path data)
                      (group-by-target-entity-batch data)))


        ;Assos relation key
        target-data-m (->> data
                           (replace-target-entity-path join)
                           (reduce assoc-target-entity-key data)
                           (group-by-target-entity-batch join))

        ;Dassoc relation
        data (->> join-coll
                  (reduce (fn [acc j]
                            (update-in acc (first j) dissoc (nth j 3))
                            ) data))]
    ;merage all of them
    (merge data target-data-m nj-data)))


(defn get-join-schema []
  (let [JoinSingleNTNSchema [(s/one s/Keyword "Join Model ")
                             (s/one s/Keyword "Join Model Id1")
                             (s/one s/Keyword "Join Model Id2")]]
    [[(s/one s/Keyword "Source Data Model")
      (s/one s/Keyword "Source Model Id")
      (s/one (s/enum join-1-n-key join-1-1-key join-n-1-key join-n-n-key) "Relationship")
      (s/one s/Keyword "Dest Model")
      (s/one s/Keyword "Dest Model Id")
      (s/optional JoinSingleNTNSchema "JoinSingleNTNSchema")]]))


(defn assoc-schema-validate [kname j acc]
  (-> acc
      (sch/assoc-schema-key (s/optional-key kname) j)
      (sch/assoc-extend-schema-key (s/optional-key kname) j)))


(defn join-emission-batch
  [j-coll]
  (mapv (fn [j]
          (condp = (nth j 2)
            join-n-n-key
            (-> j
                (update-in [0] cc/as-lower-case-keyword)
                (update-in [1] cc/as-lower-case-keyword)
                (update-in [3] cc/as-lower-case-keyword)
                (update-in [4] cc/as-lower-case-keyword)
                (update-in [5 1] cc/as-lower-case-keyword)
                (update-in [5 2] cc/as-lower-case-keyword))
            (-> j
                (update-in [0] cc/as-lower-case-keyword)
                (update-in [1] cc/as-lower-case-keyword)
                (update-in [3] cc/as-lower-case-keyword)
                (update-in [4] cc/as-lower-case-keyword)))

          ) j-coll))


(defn new-join-processor
  ([] (new-join-processor join-key))
  ([kname]
   (let [j (get-join-schema)]
     {k-name     kname
      k-validate (partial assoc-schema-validate kname j)
      k-emission (fn [j-coll sql-key-seq] (join-emission-batch j-coll))
      k-join     (fn [ks m] (do-join ks m))
      k-disjoin  (fn [ks m] (do-disjoin ks m))})))



(defn map-reverse-join
  [join-coll]
  (let [f (fn [[s-tab s-id join-key d-tab d-id [r-tab r-id r-id2] :as j]]
            (condp = join-key
              join-1-1-key [d-tab d-id join-1-1-key s-tab s-id]
              join-1-n-key [d-tab d-id join-n-1-key s-tab s-id]
              join-n-1-key [d-tab d-id join-1-n-key s-tab s-id]
              join-n-n-key [d-tab d-id join-n-n-key s-tab s-id [r-tab r-id2 r-id]]
              j))]
    (->> (map f join-coll)
         (concat join-coll)
         (distinct)
         (sort-by first)
         (into []))))


(defn group-by-join-src
  [join-coll]
  (->> join-coll
       (group-by first)
       (map (fn [[k coll]]
              {k {join-key coll}}))
       (into {})))


(defn filter-join-key-coll
  [join model-coll]
  (->> join
       (filter (fn [[_ _ rel d-table _ nr]]
                 (if (= rel join-n-n-key)
                   (some #{(first nr)} model-coll)
                   (some #{d-table} model-coll))))
       (into [])))


(defn do-join-impl
  [routput p-type tm-coll p-context]
  (if (or (cc/failed? routput)
          (= p-type map-type)
          (empty? (get-in tm-coll [0 join-key])))
    routput
    (if-let [fn-join (get-in p-context [join-key k-disjoin])]
      (-> (get-in tm-coll [0 join-key])
          (fn-join routput))
      routput)))