(ns tiesql.tools.c3p0
  (:require
    [tiesql.tools.ds :as j])
  (:import
    [com.mchange.v2.c3p0 ComboPooledDataSource]))


(defrecord C3p0datasourceImpl [conf]
  j/IDataSource
  (k-create [this]
    (if (nil? (:ds this))
      (if conf
        (->> (ComboPooledDataSource. conf)
             (assoc this :ds))
        (->> (ComboPooledDataSource.)
             (assoc this :ds)))))
  (k-close [this]
    (if-not (nil? (:ds this))
      (.close (:ds this))))
  (k-connection [this]
    (:ds this))
  (k-status [this]
    (let [^ComboPooledDataSource ds (:ds this)]
      {:conn (.getNumConnectionsDefaultUser ds)
       :idle (.getNumIdleConnectionsDefaultUser ds)
       :busy (.getNumBusyConnectionsDefaultUser ds)})))


(defn new-c3p0datasource
  ([] (new-c3p0datasource nil))
  ([conf]
   (->C3p0datasourceImpl conf)))


;(def C3p0datasource (->C3p0datasourceImpl))


