(ns tiesql.tools.http-routes
  (:use compojure.core)
  (:require [clojure.java.io :as io]
            [ring.util.response :as resp]
            [ring.middleware.params :refer [wrap-params]]
            [ring.util.response :as resp]
            [compojure.route :as route]
            [ring.middleware.multipart-params :refer [wrap-multipart-params]]
            [ring.middleware.keyword-params :refer [wrap-keyword-params]]
            [ring.middleware.format-params :as fp]
            [ring.middleware.format-response :as fr]
            [tiesql.common :as sc]
            [tiesql.tools.ds :as ds]
            [tiesql.tools.jdbc-http-adapter :as hs]))


(defn wrap-exceptions
  "Catch all system exception "
  [handler]
  (fn [request]
    (try
      (handler request)
      (catch Exception e
        (sc/debug "Http request process exception " e)
        ;  (cc/fail (select-keys request [:query-string]))
        {:status  500
         :headers {"Content-Type" "text/html"}
         :body    "Exception in server"}))))


(defn wrap-request-log
  "Log http request"
  [handler]
  (fn [req]
    (do
      (->>
        ;(select-keys req [:params :form-params :body-params :uri :request-method])
        (dissoc req [:body])
        (sc/debug "http Request "))
      (handler req))))


;(defonce ^:private tms (atom nil))
(defonce ^:dynamic track-file-name "sql.log")


(defn track []
  (slurp track-file-name))


(defn track-in-file
  [file-name new-coll]
  (with-open [wrtr (io/writer file-name :append true)]
    (doseq [w new-coll]
      (.write wrtr (str w))
      (.write wrtr "\n"))))


(defn track-start []
  #_(exec/start-tracking :track (partial track-in-file track-file-name))
  nil)


(defn track-stop []
  #_(exec/stop-tracking :track)
  nil)


(defn track-routes
  []
  (routes
    (GET "/" [] (resp/response nil #_(db/track)))
    (GET "/start" []
      (do
        #_(db/track-stop)
        "Done"))
    (GET "/stop" []
      (do
        #_(db/track-stop)
        "Done"))))


;(def query-url-str "/query")
;(def execute-url-str "/execute")

(def push-one-url "/pushone")
(def push-batch-url "/pushbatch")

(def pull-one-url "/pullone")
(def pull-batch-url "/pullbatch")



(defn tie-routes
  [db tie-atom]
  (-> (routes
        (context "/admin" []
          (routes
            (GET "/tie" [:as r]
              (->> (hs/get-sql-file-value tie-atom)
                   (resp/response)))
            (GET "/dbstatus" [:as r]
              (->> (ds/status db)
                   (resp/response)))))
        (POST pull-one-url [& params]
          (->> (hs/pull-one! tie-atom db params)
               (resp/response)))
        (POST pull-batch-url [& params]
          (->> (hs/pull-batch! tie-atom db params)
               (resp/response)))

        (POST push-one-url [& params]
          (->> (hs/push-one! tie-atom db params)
               (resp/response)))
        (POST push-batch-url [& params]
          (->> (hs/push-batch! tie-atom db params)
               (resp/response)))

        (GET "/pull" [& params]
          (->> (hs/pull-batch-with-param-read! tie-atom db params)
               (resp/response)))

        (ANY "/push" [& params]
          (->> (hs/push-one-with-param-read! tie-atom db params)
               (resp/response)))
        (GET "/" [& params]
          (->> (hs/pull-batch-with-param-read! tie-atom db params)
               (resp/response))))
      (wrap-exceptions)
      (wrap-request-log)
      (wrap-keyword-params)
      (wrap-params)
      (fp/wrap-restful-params)
      (fr/wrap-restful-response)))



(defn default-app-routes
  ([tie-routes] (default-app-routes "/tie" tie-routes))
  ([tie-routes routes-path]
   (let [r (or tie-routes (routes (ANY "/" [] "Not found ")))]
     (routes
       (GET "/" [:as {:keys [context]}] (resp/redirect (str context "/index.html")))
       (context routes-path [] r)
       ;(or resolved-ring-handler (fn [r] false))
       (GET "/ping" [] (resp/response "Ping success"))
       (route/resources "/")
       (route/not-found "Page not found")))))
