(ns tiesql.tools.http-routes
  (:use compojure.core)
  (:require [clojure.java.io :as io]
            [ring.util.response :as resp]
            [ring.middleware.params :refer [wrap-params]]
            [ring.util.response :as resp]
            [compojure.route :as route]
            [ring.middleware.multipart-params :refer [wrap-multipart-params]]
            [ring.middleware.keyword-params :refer [wrap-keyword-params]]
            [ring.middleware.format-params :as fp]
            [ring.middleware.format-response :as fr]
            [tiesql.common :as sc]
            [tiesql.tools.http-service :as hs]))


(defn wrap-exceptions
  "Catch all system exception "
  [handler]
  (fn [request]
    (try
      (handler request)
      (catch Exception e
        (sc/debug "Http request process exception " e)
        ;  (cc/fail (select-keys request [:query-string]))
        {:status  500
         :headers {"Content-Type" "text/html"}
         :body    "Exception in server"}))))


(defn wrap-request-log
  "Log http request"
  [handler]
  (fn [req]
    (do
      (->>
        ;(select-keys req [:params :form-params :body-params :uri :request-method])
        (dissoc req [:body])
        (sc/debug "http Request "))
      (handler req))))


;(defonce ^:private tms (atom nil))
(defonce ^:dynamic track-file-name "sql.log")


(defn track []
  (slurp track-file-name))


(defn track-in-file
  [file-name new-coll]
  (with-open [wrtr (io/writer file-name :append true)]
    (doseq [w new-coll]
      (.write wrtr (str w))
      (.write wrtr "\n"))))


(defn track-start []
  #_(exec/start-tracking :track (partial track-in-file track-file-name))
  nil)


(defn track-stop []
  #_(exec/stop-tracking :track)
  nil)


(defn track-routes
  []
  (routes
    (GET "/" [] (resp/response nil #_(db/track)))
    (GET "/start" []
      (do
        #_(db/track-stop)
        "Done"))
    (GET "/stop" []
      (do
        #_(db/track-stop)
        "Done"))))


;(def query-url-str "/query")
;(def execute-url-str "/execute")


(defn tie-routes
  [tie-atom db]
  (-> (routes
        (context "/admin" []
          (routes
            (GET "/tie" [:as r]
              (->> (hs/get-sql-file-value tie-atom)
                   (resp/response)))))
        (POST "/read" [& params :as r]
          (->> (hs/read! tie-atom db params)
               (resp/response)))
        (POST "/write" [& params :as r]
          (->> (hs/write! tie-atom db params)
               (resp/response)))
        (GET "/" [& params :as r]
          (->> (hs/query-with-param-read tie-atom db params)
               (resp/response)))
        (POST "/" [:as r]
          (let [body-params (:body-params r)]
            (->> (hs/write! tie-atom db body-params)
                 (resp/response)))))
      (wrap-exceptions)
      (wrap-request-log)
      (wrap-keyword-params)
      (wrap-params)
      (fp/wrap-restful-params)
      (fr/wrap-restful-response)))


(defn app-routes [tie-routes]
  (routes
    (GET "/" [:as {:keys [context]}] (resp/redirect (str context "/index.html")))
    (context "/tie" [] tie-routes)
    (GET "/ping" [] (resp/response "Ping success"))
    (route/resources "/")
    (route/not-found "Page not found")))
