(ns mongodbsession.mongodb_session
  (:require [monger.collection :as db]
	    [ring.middleware.session.store :as ringstore])
  (:import [java.util UUID Date]))

(deftype MongodbStore [collection-name auto-key-change?]
  ringstore/SessionStore
  (read-session [_ key]
      (if-let [entity (and key
        (db/find-map-by-id collection-name key))]
		  entity {}))
  (write-session [_ key data]
		 ;;work around for (name ::keyword) -> "keyword"
		 (let [data (zipmap (map #(if (and (keyword? %) (namespace %))
					    (-> % str (.substring 1)) %)
					 (keys data))
				    (vals data))
		       entity (and key (db/find-map-by-id collection-name key))
		       key-change? (or (not entity) auto-key-change?)
		       newkey (if key-change?
				(str (UUID/randomUUID)) key)]
		   (if entity
		     (do (if key-change?
			   (do (db/remove-by-id collection-name key)
			       (db/insert collection-name
					      (assoc data :_id newkey :_date (:_date entity))))
			   (db/update-by-id collection-name newkey
					  (assoc data :_date (:_date entity))))
			 newkey)
		     (do (db/insert collection-name (assoc data :_id newkey :_date (Date.)))
			 newkey))))
  (delete-session [_ key]
		  (db/remove-by-id collection-name key)
		  nil))

(defn mongodb-store
  ([] (mongodb-store {}))
  ([opt]
    (let [collection-name (opt :collection-name :ring_sessions)
	   auto-key-change? (opt :auto-key-change? false)]
       (MongodbStore. "ring_sessions" auto-key-change?))))
