/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentVector;
import datahike.java.Datahike;
import datahike.java.IEntity;
import datahike.java.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class DatahikeTest {
    private String uri = "datahike:mem://test-empty-db";
    private Object conn;
    private Object schema = Clojure.read((String)" [{:db/ident :name\n                 :db/valueType :db.type/string\n                 :db/unique :db.unique/identity\n                 :db/index true\n                 :db/cardinality :db.cardinality/one}\n                {:db/ident :age\n                 :db/valueType :db.type/long\n                 :db/cardinality :db.cardinality/one}]");
    private Date firstDate;
    private String query;

    @Before
    public void setUp() throws Exception {
        Datahike.deleteDatabase(this.uri);
    }

    @After
    public void tearDown() throws Exception {
    }

    private void transactOnce() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        this.query = "[:find ?n ?a :where [?e :name ?n] [?e :age ?a]]";
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":name"), "Alice", Util.k(":age"), 25L), Util.map(Util.k(":name"), "Bob", Util.k(":age"), 30L)));
    }

    @Test
    public void db() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Assert.assertEquals((Object)Datahike.db(this.conn), (Object)Datahike.dConn(this.conn));
    }

    @Test
    public void databaseExists() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        Assert.assertTrue((boolean)Datahike.databaseExists(this.uri));
        Assert.assertFalse((boolean)Datahike.databaseExists("datahike:mem://not-exists"));
    }

    @Test
    public void queryWithDBAndInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set<PersistentVector> set = Datahike.q(this.query, Datahike.dConn(this.conn), Clojure.read((String)"[\"Alice\"]"));
        Object[] objectArray = set.stream().map(persistentVector -> persistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithJavaArrayInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set<PersistentVector> set = Datahike.q(this.query, Datahike.dConn(this.conn), new String[]{"Alice"});
        Object[] objectArray = set.stream().map(persistentVector -> persistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithLocalInputDB() {
        Object object = Clojure.read((String)"[[1 :name 'Ivan'] [1 :age  19] [1 :aka  \"dragon_killer_94\"] [1 :aka  '-=autobot=-']]");
        Set<PersistentVector> set = Datahike.q("[:find  ?n ?a :where [?e :aka \"dragon_killer_94\"] [?e :name ?n] [?e :age  ?a]]", object);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void queryWithDB() {
        Datahike.createDatabase(this.uri);
        this.conn = Datahike.connect(this.uri);
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/ident"), Util.k(":name"), Util.k(":db/valueType"), Util.k(":db.type/string"), Util.k(":db/cardinality"), Util.k(":db.cardinality/one"))));
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":name"), "Alice")));
        Object object = Util.deref.invoke(this.conn);
        Set<PersistentVector> set = Datahike.q("[:find ?e :where [?e :name]]", object);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        set = Datahike.q("[:find ?v :where [_ :name ?v]]", object);
        Assert.assertEquals((Object)PersistentHashSet.create(Arrays.asList(PersistentVector.create((Object[])new Object[]{"Alice"}))), set);
    }

    @Test
    public void history() {
        this.transactOnce();
        Set<PersistentVector> set = Datahike.q(this.query, Datahike.history(Datahike.dConn(this.conn)));
        Object[] objectArray = set.stream().map(persistentVector -> persistentVector.get(0)).toArray();
        Assert.assertEquals((Object[])new String[]{"Alice", "Bob"}, (Object[])objectArray);
    }

    @Test
    public void asOfAndSince() {
        this.transactOnce();
        this.firstDate = new Date();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), Util.vec(Util.k(":name"), "Alice"), Util.k(":age"), 30L)));
        Set<PersistentVector> set = Datahike.q(this.query, Datahike.asOf(Datahike.dConn(this.conn), this.firstDate));
        Assert.assertEquals((long)2L, (long)set.size());
        set = Datahike.q(this.query, Datahike.since(Datahike.dConn(this.conn), this.firstDate));
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void pullAndPullMany() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        Map map = Datahike.pull(Datahike.dConn(this.conn), "[*]", 10);
        Assert.assertEquals((Object)"Joe", map.get(Util.k(":name")));
        map = Datahike.pull(Datahike.dConn(this.conn), "[*]", Util.vec(Util.k(":name"), "Alice"));
        Assert.assertEquals((Object)"Alice", map.get(Util.k(":name")));
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 20, Util.k(":name"), "Jane", Util.k(":age"), 25L)));
        List list = Datahike.pullMany(Datahike.dConn(this.conn), "[*]", Util.vec(10, 20));
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void release() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Datahike.release(this.conn);
    }

    @Test
    public void seekDatoms() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Datahike.transact(this.conn, (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]"));
        List list = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 10);
        list.stream().map(persistentVector -> {
            Assert.assertTrue(((Integer)persistentVector.get(0) >= 10 ? 1 : 0) != 0);
            return null;
        });
        list = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 10, Util.k(":name"));
        list.stream().map(persistentVector -> {
            int n = (Integer)persistentVector.get(0);
            Assert.assertTrue((n == 10 && persistentVector.get(1).equals(":name") || n > 10 ? 1 : 0) != 0);
            return null;
        });
        list = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 30, Util.k(":name"), "Sergey");
        list.stream().map(persistentVector -> {
            int n = (Integer)persistentVector.get(0);
            Assert.assertTrue((n == 30 && persistentVector.get(1).equals(":name") && persistentVector.get(2).equals("Sergey") || n > 30 ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void tempId() {
        Long l = Datahike.tempId(Util.k(":db.part/user"));
        Assert.assertTrue((l < 0L ? 1 : 0) != 0);
        l = Datahike.tempId(Util.k(":db.part/user"), -10000L);
        Assert.assertEquals((long)-10000L, (long)l);
    }

    @Test
    public void entity() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        IEntity iEntity = Datahike.entity(Datahike.dConn(this.conn), 10);
        Object object = iEntity.valAt(Util.k(":name"));
        Assert.assertEquals((Object)"Joe", (Object)object);
    }

    @Test
    public void entityDb() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        IEntity iEntity = Datahike.entity(Datahike.dConn(this.conn), 10);
        Object object = Datahike.entityDb(iEntity);
        Assert.assertNotNull((Object)object);
    }

    @Test
    public void filterAndIsFiltered() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Assert.assertFalse((boolean)Datahike.isFiltered(Datahike.dConn(this.conn)));
        Datahike.transact(this.conn, (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]"));
        Object object = Datahike.filter(Datahike.dConn(this.conn), Clojure.read((String)"(fn [_ datom] (not= :age (:a datom)))"));
        Assert.assertTrue((boolean)Datahike.isFiltered(object));
    }

    @Test
    public void dbWith() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        PersistentVector persistentVector = (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]");
        Object object = Datahike.dbWith(Datahike.dConn(this.conn), persistentVector);
        this.query = "[:find ?a :in $ :where [?e :age ?a]]";
        Set<PersistentVector> set = Datahike.q(this.query, object);
        Assert.assertTrue((set.size() == 3 ? 1 : 0) != 0);
    }

    public static boolean run() {
        Result result = JUnitCore.runClasses((Class[])new Class[]{DatahikeTest.class});
        System.out.println("\n");
        List list = result.getFailures();
        for (Failure failure : list) {
            System.out.println("Junit Failure: " + failure.toString());
        }
        System.out.println("Java Bindings test failure count: " + list.size());
        return result.wasSuccessful();
    }
}

