(ns currency.currencies.core
  (:require [utilis.types.string :refer [->string]]
            [clojure.string :as st]))

(defmulti monetary-unit->string :currency)

(defmethod monetary-unit->string :default
  [{:keys [currency amount]}]
  (str
   (st/upper-case
    (->string currency))
   amount))
