(ns currency.util.number
  (:require [clojure.spec.alpha :as s]))

;;; API

(defn split-decimal
  [amount group-size]
  {:pre [(s/valid? ::amount amount)]
   :pos [(s/every ::amount %)]}
  [(quot amount group-size)
   (mod amount group-size)])

;;; Specs

(s/def ::amount integer?)
