(ns currency.currencies.usd
  (:require [currency.currencies.core :as currency]
            [currency.util.number :refer [split-decimal]]))

(defmethod currency/monetary-unit->decimal-string :usd
  [{:keys [amount]}]
  (let [[dollars cents] (split-decimal amount 100)]
    (str dollars "."
         (cond
           (zero? cents) "00"
           (< cents 10) (str "0" cents)
           :else cents))))

(defmethod currency/monetary-unit->string :usd
  [{:keys [amount] :as monetary-unit}]
  (str "$" (currency/monetary-unit->decimal-string monetary-unit)))
