(ns currency.util.number
  (:require [clojure.spec.alpha :as s]))

;;; API

(defn split-decimal
  [amount group-size]
  {:pre [(s/valid? :currency.core/amount amount)]
   :post [(s/valid? (s/every :currency.core/amount) %)]}
  [(quot amount group-size)
   (mod amount group-size)])
