(ns hub.core
  (:require [clojure.string :as st]

            [hub.schema :as hs]

            [reloaded.repl :as repl]

            [schema.core :as s]

            [taoensso.timbre :as log]

            [utilis.types.number :refer [string->long]]
            [utilis.map :refer [map-keys map-vals]]

            [com.stuartsierra.component :as component :refer [Lifecycle]]))

(s/defn init!
  [system :- hs/Component]
  (repl/set-init! (constantly system)))

(def go repl/go)
(def stop repl/stop)
(def start go)
