(ns re-frame-auth.util.id
  (:require [clj-uuid :as uuid]

            [buddy.core.hash :as buddy-hash]
            [buddy.core.codecs :as buddy-codecs]

            [clojure.string :as st]))

(defn uuid
  []
  (str (uuid/v4)))

(defn keyword->string
  [kw]
  (str (when-let [ns (namespace kw)]
         (str ns "/"))
       (name kw)))

(defn generate-auth-key
  "Generate an auth key of form <type>/<hashed-primary-key-value>"
  [{:keys [primary-key type] :as auth}]
  (str
   (st/replace (keyword->string type) #"/" "_") "/"
   (buddy-codecs/bytes->hex
    (buddy-hash/md5
     (get auth primary-key)))))
