(ns re-frame-auth.stores.core
  (:require [re-frame-auth.protocols :as proto]
            [re-frame-auth.util.spec :refer [validate]]
            [clojure.spec.alpha :as s]))

;;; API

(defn auth-record
  [type data & {:keys [primary-key]}]
  (let [primary-key (or primary-key type)]
    (validate
     :auth-store/record
     (merge data {:type type
                  :primary-key primary-key}))))

;;; Specs

(s/def :auth-store-record/has-primary-key
  (fn [{:keys [primary-key] :as record}]
    (contains? record primary-key)))

(s/def :auth-store-record/type keyword?)
(s/def :auth-store-record/primary-key keyword?)
(s/def :auth-store-record/user-id string?)
(s/def :auth-store/record
  (s/and
   (s/keys :req-un
           [:auth-store-record/type
            :auth-store-record/primary-key]
           :opt-un
           [:auth-store-record/user-id])
   :auth-store-record/has-primary-key))

(s/def :store/auth (partial satisfies? proto/AuthStore))
(s/def :store/user (partial satisfies? proto/UserStore))
