(ns rethink.integrant
  (:require [rethink.core :as rt]
            [integrant.core :as ig]))

(defmethod ig/init-key :rethink.integrant/connection
  [_ {:keys [db hostname port] :as opts}]
  (let [conn (rt/connect opts)]
    (when-not (rt/db-exists? db conn)
      (rt/create-db! db conn))
    conn))

(defmethod ig/halt-key! :rethink.integrant/connection
  [_ conn]
  (rt/close! conn))
