(ns tidy.util
  (:require [tidy.core :as tidy])
  (:import [java.util.concurrent LinkedBlockingQueue]))

(def complete-token :tidy/complete-token)

(defn queue->seq
  [queue]
  (let [value (.take queue)]
    (when-not (= complete-token value)
      (cons value (queue->seq queue)))))

(defn reaction->seq
  [reaction]
  (let [queue (LinkedBlockingQueue. 1)]
    (tidy/subscribe
     reaction queue
     {:on-dispose (fn [] (.offer queue complete-token))
      :on-value (fn [value] (.put queue value))})
    (concat
     (lazy-seq (.take queue))
     (queue->seq queue))))

(defn into-atom
  [to from]
  {:pre [(instance? clojure.lang.IRef to)]}

  (cond

    (instance? LinkedBlockingQueue from)
    (future
      (loop []
        (let [v (.take from)]
          (when-not (= v complete-token)
            (try (reset! to v)
                 (catch Exception e
                   (println e)))
            (recur)))))

    :else (throw
           (ex-info
            "Unable to convert"
            {:to to
             :from from}))))
