(ns material-ui-reagent.core
  (:refer-clojure :exclude [Box List])
  (:require
   ["@material-ui/core" :as material-ui]
   ["@material-ui/core/styles" :refer [makeStyles]]
   [goog.object :as go]
   [reagent.core :as reagent]))

(def mui material-ui)

(defn- adapt
  "Make reagent component from Material-UI core"
  [c]
  (reagent/adapt-react-class (go/get mui c)))

;;; Reagent components

(def AppBar (adapt "AppBar"))
(def Avatar (adapt "Avatar"))
(def Backdrop (adapt "Backdrop"))
(def Badge (adapt "Badge"))
(def BottomNavigation (adapt "BottomNavigation"))
(def BottomNavigationAction (adapt "BottomNavigationAction"))
(def Box (adapt "Box"))
(def Breadcrumbs (adapt "Breadcrumbs"))
(def Button (adapt "Button"))
(def ButtonBase (adapt "ButtonBase"))
(def ButtonGroup (adapt "ButtonGroup"))
(def Card (adapt "Card"))
(def CardActionArea (adapt "CardActionArea"))
(def CardActions (adapt "CardActions"))
(def CardContent (adapt "CardContent"))
(def CardHeader (adapt "CardHeader"))
(def CardMedia (adapt "CardMedia"))
(def Checkbox (adapt "Checkbox"))
(def Chip (adapt "Chip"))
(def CircularProgress (adapt "CircularProgress"))
(def ClickAwayListener (adapt "ClickAwayListener"))
(def Collapse (adapt "Collapse"))
(def Container (adapt "Container"))
(def CssBaseline (adapt "CssBaseline"))
(def Dialog (adapt "Dialog"))
(def DialogActions (adapt "DialogActions"))
(def DialogContent (adapt "DialogContent"))
(def DialogContentText (adapt "DialogContentText"))
(def DialogTitle (adapt "DialogTitle"))
(def Divider (adapt "Divider"))
(def Drawer (adapt "Drawer"))
(def ExpansionPanel (adapt "ExpansionPanel"))
(def ExpansionPanelActions (adapt "ExpansionPanelActions"))
(def ExpansionPanelDetails (adapt "ExpansionPanelDetails"))
(def ExpansionPanelSummary (adapt "ExpansionPanelSummary"))
(def Fab (adapt "Fab"))
(def Fade (adapt "Fade"))
(def FilledInput (adapt "FilledInput"))
(def FormControl (adapt "FormControl"))
(def FormControlLabel (adapt "FormControlLabel"))
(def FormGroup (adapt "FormGroup"))
(def FormHelperText (adapt "FormHelperText"))
(def FormLabel (adapt "FormLabel"))
(def Grid (adapt "Grid"))
(def GridList (adapt "GridList"))
(def GridListTile (adapt "GridListTile"))
(def GridListTileBar (adapt "GridListTileBar"))
(def Grow (adapt "Grow"))
(def Hidden (adapt "Hidden"))
(def Icon (adapt "Icon"))
(def IconButton (adapt "IconButton"))
(def Input (adapt "Input"))
(def InputAdornment (adapt "InputAdornment"))
(def InputBase (adapt "InputBase"))
(def InputLabel (adapt "InputLabel"))
(def LinearProgress (adapt "LinearProgress"))
(def Link (adapt "Link"))
(def List (adapt "List"))
(def ListItem (adapt "ListItem"))
(def ListItemAvatar (adapt "ListItemAvatar"))
(def ListItemIcon (adapt "ListItemIcon"))
(def ListItemSecondaryAction (adapt "ListItemSecondaryAction"))
(def ListItemText (adapt "ListItemText"))
(def ListSubheader (adapt "ListSubheader"))
(def Menu (adapt "Menu"))
(def MenuItem (adapt "MenuItem"))
(def MenuList (adapt "MenuList"))
(def MobileStepper (adapt "MobileStepper"))
(def Modal (adapt "Modal"))
(def NativeSelect (adapt "NativeSelect"))
(def NoSsr (adapt "NoSsr"))
(def OutlinedInput (adapt "OutlinedInput"))
(def Paper (adapt "Paper"))
(def Popover (adapt "Popover"))
(def Popper (adapt "Popper"))
(def Portal (adapt "Portal"))
(def Radio (adapt "Radio"))
(def RadioGroup (adapt "RadioGroup"))
(def RootRef (adapt "RootRef"))
(def Select (adapt "Select"))
(def Slide (adapt "Slide"))
(def Slider (adapt "Slider"))
(def Snackbar (adapt "Snackbar"))
(def SnackbarContent (adapt "SnackbarContent"))
(def Step (adapt "Step"))
(def StepButton (adapt "StepButton"))
(def StepConnector (adapt "StepConnector"))
(def StepContent (adapt "StepContent"))
(def StepIcon (adapt "StepIcon"))
(def StepLabel (adapt "StepLabel"))
(def Stepper (adapt "Stepper"))
(def SvgIcon (adapt "SvgIcon"))
(def SwipeableDrawer (adapt "SwipeableDrawer"))
(def Switch (adapt "Switch"))
(def Tab (adapt "Tab"))
(def Table (adapt "Table"))
(def TableBody (adapt "TableBody"))
(def TableCell (adapt "TableCell"))
(def TableContainer (adapt "TableContainer"))
(def TableFooter (adapt "TableFooter"))
(def TableHead (adapt "TableHead"))
(def TablePagination (adapt "TablePagination"))
(def TableRow (adapt "TableRow"))
(def TableSortLabel (adapt "TableSortLabel"))
(def Tabs (adapt "Tabs"))
(def TabScrollButton (adapt "TabScrollButton"))
(def TextField (adapt "TextField"))
(def TextareaAutosize (adapt "TextareaAutosize"))
(def Toolbar (adapt "Toolbar"))
(def Tooltip (adapt "Tooltip"))
(def Typography (adapt "Typography"))
(def Unstable_TrapFocus (adapt "Unstable_TrapFocus"))
(def Zoom (adapt "Zoom"))
