/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.fruitbat.atrio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public class ATRWriter {
    static final int RAW_MIN = 32;
    static final int RAW_MAX = 126;
    static final int ESCAPE = 92;
    static final int UNICODE_E = 117;
    static final int F_START = 58;
    static final int F_START_E = 99;
    static final int F_END = 9;
    static final int F_END_E = 116;
    static final int R_START = 10;
    static final int R_START_E = 110;
    static final int R_END = 37;
    static final int R_END_E = 112;
    static final int CR = 13;
    static final int CR_E = 114;
    static final int ZERO = 48;
    static final int A = 97;
    private final OutputStream out;

    public ATRWriter(OutputStream out) {
        this.out = out;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void startRecord() throws IOException {
        this.out.write(10);
    }

    public void endRecord() throws IOException {
        this.out.write(37);
    }

    public void writeRecord(Collection<String> fields) throws IOException {
        this.startRecord();
        for (String f : fields) {
            this.write(f);
        }
        this.endRecord();
    }

    public void write(String field) throws IOException {
        this.out.write(58);
        int charIndex = 0;
        block8: while (charIndex < field.length()) {
            int codePoint = field.codePointAt(charIndex);
            charIndex += Character.charCount(codePoint);
            switch (codePoint) {
                case 92: {
                    this.out.write(92);
                    this.out.write(92);
                    continue block8;
                }
                case 58: {
                    this.out.write(92);
                    this.out.write(99);
                    continue block8;
                }
                case 9: {
                    this.out.write(92);
                    this.out.write(116);
                    continue block8;
                }
                case 10: {
                    this.out.write(92);
                    this.out.write(110);
                    continue block8;
                }
                case 37: {
                    this.out.write(92);
                    this.out.write(112);
                    continue block8;
                }
                case 13: {
                    this.out.write(92);
                    this.out.write(114);
                    continue block8;
                }
            }
            if (codePoint >= 32 && codePoint <= 126) {
                this.out.write(codePoint);
                continue;
            }
            this.out.write(92);
            this.out.write(117);
            for (int shift = 20; shift >= 0; shift -= 4) {
                int nyb = (codePoint >>> shift) % 16;
                this.out.write(nyb < 10 ? 48 + nyb : 87 + nyb);
            }
        }
        this.out.write(9);
    }
}

