/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import com.zarkonnen.fruitbat.atrio.ATRWriter;
import com.zarkonnen.longan.Longan;
import com.zarkonnen.longan.Util;
import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LetterTestDataCategoriser
implements KeyListener {
    Longan longan;
    Canvas c;
    String letterIdentification = null;
    BufferedImage img;
    BufferedImage letterImg;
    Rectangle letterR;
    Letter prevLetter = null;
    String prevLetterIdentification = null;
    static final int REFERENCE_INTENSITY_BOUNDARY = 165;

    public LetterTestDataCategoriser(Longan l) {
        this.longan = l;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: sourceFile, targetFolder, fontName, sourceName");
            return;
        }
        new LetterTestDataCategoriser(Longan.getDefaultImplementation()).run(new File(args[0]), new File(args[1]), args[2], args[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(File sourceFile, File targetFolder, String fontName, String sourceName) {
        HashMap<String, ATRWriter> offsetWriters = new HashMap<String, ATRWriter>();
        HashMap<String, ATRWriter> sizeWriters = new HashMap<String, ATRWriter>();
        HashMap<String, ATRWriter> fontWriters = new HashMap<String, ATRWriter>();
        HashMap<String, ATRWriter> sourceWriters = new HashMap<String, ATRWriter>();
        HashMap<String, ATRWriter> prevLetterWriters = new HashMap<String, ATRWriter>();
        JFrame fr = new JFrame("Character identification");
        this.c = new Canvas(){

            @Override
            public void paint(Graphics g) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, LetterTestDataCategoriser.this.c.getWidth(), LetterTestDataCategoriser.this.c.getHeight());
                if (LetterTestDataCategoriser.this.img == null || LetterTestDataCategoriser.this.letterR == null) {
                    return;
                }
                g.drawImage(LetterTestDataCategoriser.this.img, 0, 0, 200, 200, LetterTestDataCategoriser.this.letterR.x - 100, LetterTestDataCategoriser.this.letterR.y - 100, LetterTestDataCategoriser.this.letterR.x + 100, LetterTestDataCategoriser.this.letterR.y + 100, null, null);
                g.setColor(new Color(0, 0, 0, 63));
                g.fillRect(0, 0, LetterTestDataCategoriser.this.c.getWidth(), LetterTestDataCategoriser.this.c.getHeight());
                g.drawImage(LetterTestDataCategoriser.this.letterImg, 100, 100, null);
                if (LetterTestDataCategoriser.this.prevLetter != null) {
                    g.setColor(Color.RED);
                    g.drawRect(LetterTestDataCategoriser.this.prevLetter.x - LetterTestDataCategoriser.this.letterR.x + 100, LetterTestDataCategoriser.this.prevLetter.y - LetterTestDataCategoriser.this.letterR.y + 100, LetterTestDataCategoriser.this.prevLetter.width, LetterTestDataCategoriser.this.prevLetter.height);
                    g.drawString(LetterTestDataCategoriser.this.prevLetterIdentification, LetterTestDataCategoriser.this.prevLetter.x - LetterTestDataCategoriser.this.letterR.x + 100, LetterTestDataCategoriser.this.prevLetter.y - LetterTestDataCategoriser.this.letterR.y + 100);
                }
            }
        };
        fr.add(this.c);
        fr.addKeyListener(this);
        this.c.addKeyListener(this);
        fr.setSize(200, 200);
        fr.setVisible(true);
        try {
            this.img = ImageIO.read(sourceFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(fr, "Can't read file " + sourceFile + ":\n" + e.getMessage());
            fr.dispose();
            return;
        }
        HashMap md = new HashMap();
        Result result = this.longan.process(this.img);
        this.img = result.img;
        File srcF = new File(targetFolder, "sources");
        if (!srcF.exists()) {
            srcF.mkdirs();
        }
        int sourceFileID = 0;
        while (new File(srcF, sourceFileID + ".jpg").exists()) {
            ++sourceFileID;
        }
        try {
            ImageIO.write((RenderedImage)result.img, "jpg", new File(srcF, sourceFileID + ".jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int blackWhiteBoundary = 0;
        if (md.containsKey("blackWhiteBoundary")) {
            int intensityBoundary = Integer.parseInt((String)md.get("blackWhiteBoundary"));
            blackWhiteBoundary = (165 - intensityBoundary) * 3 / 4;
        }
        for (Column column : result.columns) {
            for (Line line : column.lines) {
                for (Word word : line.words) {
                    this.prevLetter = null;
                    this.prevLetterIdentification = null;
                    for (Letter r : word.letters) {
                        File charF;
                        String charS;
                        this.letterIdentification = null;
                        this.letterR = r;
                        this.letterImg = Util.cropMaskAndAdjust(this.img, r, blackWhiteBoundary);
                        this.c.repaint();
                        while (this.letterIdentification == null) {
                            LetterTestDataCategoriser letterTestDataCategoriser = this;
                            synchronized (letterTestDataCategoriser) {
                                try {
                                    this.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    JOptionPane.showMessageDialog(fr, e.getMessage());
                                    fr.dispose();
                                    return;
                                }
                            }
                        }
                        if (!targetFolder.exists()) {
                            targetFolder.mkdirs();
                        }
                        String string = this.letterIdentification.equals("/") ? "slash" : (this.letterIdentification.equals(".") ? "period" : (charS = this.letterIdentification.equals(":") ? "colon" : this.letterIdentification));
                        if (!charS.toLowerCase().equals(charS)) {
                            charS = charS.toLowerCase() + "-uc";
                        }
                        if (!(charF = new File(targetFolder, charS)).exists()) {
                            charF.mkdirs();
                        }
                        int n = 0;
                        while (new File(charF, n + ".png").exists()) {
                            ++n;
                        }
                        try {
                            ATRWriter w;
                            ImageIO.write((RenderedImage)this.letterImg, "png", new File(charF, n + ".png"));
                            if (this.prevLetter != null) {
                                if (!prevLetterWriters.containsKey(charS)) {
                                    File prevLetterF = new File(targetFolder, charS + "-prevletter.atr");
                                    prevLetterWriters.put(charS, new ATRWriter(new FileOutputStream(prevLetterF, true)));
                                }
                                w = (ATRWriter)prevLetterWriters.get(charS);
                                w.startRecord();
                                w.write("" + n);
                                w.write(this.prevLetterIdentification);
                                w.write("" + (double)(r.x - this.prevLetter.x - this.prevLetter.width) * 1.0 / (double)r.width);
                                w.endRecord();
                                w.flush();
                            }
                            if (!fontWriters.containsKey(charS)) {
                                File fontF = new File(targetFolder, charS + "-font.atr");
                                fontWriters.put(charS, new ATRWriter(new FileOutputStream(fontF, true)));
                            }
                            w = (ATRWriter)fontWriters.get(charS);
                            w.startRecord();
                            w.write("" + n);
                            w.write(fontName);
                            w.endRecord();
                            w.flush();
                            if (!sourceWriters.containsKey(charS)) {
                                File sourceF = new File(targetFolder, charS + "-source.atr");
                                sourceWriters.put(charS, new ATRWriter(new FileOutputStream(sourceF, true)));
                            }
                            w = (ATRWriter)sourceWriters.get(charS);
                            w.startRecord();
                            w.write("" + n);
                            w.write(sourceName);
                            w.write(sourceFileID + ".jpg");
                            w.write("" + r.x);
                            w.write("" + r.y);
                            w.write("" + r.width);
                            w.write("" + r.height);
                            w.endRecord();
                            w.flush();
                            if (!offsetWriters.containsKey(charS)) {
                                File offF = new File(targetFolder, charS + "-offset.atr");
                                offsetWriters.put(charS, new ATRWriter(new FileOutputStream(offF, true)));
                            }
                            w = (ATRWriter)offsetWriters.get(charS);
                            w.startRecord();
                            w.write("" + n);
                            w.write("" + r.relativeLineOffset);
                            w.endRecord();
                            w.flush();
                            if (!sizeWriters.containsKey(charS)) {
                                File sizeF = new File(targetFolder, charS + "-size.atr");
                                sizeWriters.put(charS, new ATRWriter(new FileOutputStream(sizeF, true)));
                            }
                            w = (ATRWriter)sizeWriters.get(charS);
                            w.startRecord();
                            w.write("" + n);
                            w.write("" + r.relativeSize);
                            w.endRecord();
                            w.flush();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(fr, "Can't read file " + sourceFile + ":\n" + e.getMessage());
                            fr.dispose();
                            return;
                        }
                        this.prevLetter = r;
                        this.prevLetterIdentification = this.letterIdentification;
                    }
                }
            }
        }
        for (ATRWriter w : offsetWriters.values()) {
            try {
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ATRWriter w : sizeWriters.values()) {
            try {
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ATRWriter w : fontWriters.values()) {
            try {
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ATRWriter w : prevLetterWriters.values()) {
            try {
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ATRWriter w : sourceWriters.values()) {
            try {
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fr.dispose();
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        this.letterIdentification = new String(new char[]{ke.getKeyChar()});
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 27) {
            this.prevLetter = null;
            this.prevLetterIdentification = null;
            this.c.repaint();
            return;
        }
    }
}

